<?php
/**
 * renew access ticket
 *
 * @version $Id$
 */
require_once dirname(__FILE__ ) . '/backend.php';

class DiscussControllerRenew extends DiscussControllerBackend
{
    /**
     * Constructor
     */
    function DiscussControllerRenew()
    {
        $this->_control = 'renew';
        $this->viewName = 'join';

        $this->context =& new DiscussGeneralContext();
        $this->context->accept('discuss_id', 'd');
    }

    /**
     * @param DiscussView $view
     * @return boolean
     */
    function action(&$view)
    {
        //validity session
        $handler_attendee =& $this->load('attendee');
        $attendee =& $handler_attendee->getActive($this->context);
        if (!$attendee) {
            $this->errorMsg = $handler_attendee->getErrors();
            return false;
        }

        //check validity of discussion
        $handler_discussion =& $this->load('discussion');
        $discussion =& $handler_discussion->get($this->context);

        //check user permission
        if (!$this->checkPermission($discussion, $attendee)) {
            return false;
        }

        //asign cache infomation to view
        $data = null;
        if (!$handler_discussion->cache($this->context, $data, $view)) {
            $this->errorMsg = $handler_discussion->getErrors();
            return false;
        }

        //update attendee list
        $handler_attendee->renew($this->context);

        //view
        $view->incArray('attendee');
        $handler_attendee->assign($view, $this->context);
        $view->endArray();

        $view->setEnv(DISCUSS_DATE_SHORT, $attendee->get('timeoffset'));
        $view->incArray('message');
        $message =& $this->load('message');
        $message->assign($view, $this->context, 2);
        $view->endArray();

        return true;
    }
}
?>