<?php
/**
 * @version $Id$
 */
require_once dirname(__FILE__ ) . '/backend.php';

class DiscussContextSearch extends DiscussGeneralContext
{
    /**
     * Constructor
     */
    function DiscussControllerSearch()
    {
        $this->accept('discuss_id', 'd');
        $this->accept('query', 'q', 'string');
        $this->accept('action', 'a');
        $this->accept('andor', 'o');
        $this->accept('uid', 'u');
        $this->accept('start', 's');
        $this->accept('color', 'c');

        if ($this->get('andor') < 2) {
            $this->set('queryarray', preg_split('/[\s,]+/', $this->get('query')));
        } else {
            $this->set('queryarray', array($this->get('query')));
        }
    }
}

class DiscussControllerSearch extends DiscussControllerBackend
{
    /**
     * Constructor
     */
    function DiscussControllerSearch()
    {
        $this->_control = 'search';
        $this->context =& new DiscussContextSearch();
    }

    /**
     * @param DiscussView $view
     * @return boolean
     */
    function action(&$view)
    {

        if (count($temp_queries) == 0) {
            redirect_header('search.php', 2, sprintf(_SR_KEYTOOSHORT, $xoopsConfigSearch['keyword_min']));
            exit();
        }


        $handler_attendee =& $this->load('attendee');
        if (!$attendee =& $handler_attendee->get($this->context)) {
            return false;
        }

        $handler =& $this->load('message');
        if ($handler->search($view, $this->context)) {
            return true;
        }

        $this->errorMsg = $handler->getErrors();
        return false;
    }
}
?>