<?php
/**
 * @version $Id$
 */
if (!class_exists('DiscussDiscussion')) {
require_once DISCUSS_PATH . '/class/general/xoopstableobject.php';

class DiscussDiscussion extends XoopsTableObject
{
	function DiscussDiscussion()
	{
		// call parent constructor
		$this->XoopsTableObject();

		// define object elements
		$this->initVar('discuss_id', XOBJ_DTYPE_INT, null, true);
		$this->initVar('subject', XOBJ_DTYPE_TXTBOX, null, true, 120);
		$this->initVar('description', XOBJ_DTYPE_TXTAREA, '', false);
		$this->initVar('open_time', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('close_time', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('closed', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('access_key', XOBJ_DTYPE_TXTBOX, '', false);
		$this->initVar('key_term', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('perm_type', XOBJ_DTYPE_INT, 0, false);

		// define primary key
		$this->setKeyFields(array('discuss_id'));
		$this->setAutoIncrementField('discuss_id');
		$this->setNameField('subject');
	}

	function checkVar_open_time($value)
	{
		if (!is_numeric($value)) {
			$this->cleanVars['open_time'] = strtotime($value);
		}
	}

	function checkVar_close_time($value)
	{
		if (!is_numeric($value)) {
			$this->cleanVars['close_time'] = strtotime($value);
		}
	}
}

class DiscussDiscussionHandler extends XoopsTableObjectHandler
{
	/**
	 * database table name
	 *
	 * @var string
	 */
	var $tableName = 'discuss';

	/**
	 * Get discussion object list
	 *
	 * @param array $user_permitted_ids
	 * @param array[optional] $specified_ids
	 * @return array[reference] of discussion object
	 */
	function &getDiscussions($user_permitted_ids = null, $specified_ids = null)
	{
		$criteria =& new CriteriaCompo();
		// perm_type 0:allow any, 1:except guest, 2:specified user only
		if (!isset($user_permitted_ids)) {
			$_criteria = new Criteria('perm_type', 0);
		} elseif (count($user_permitted_ids) == 0) {
			$_criteria = new Criteria('perm_type', 1, '<=');
		} else {
			$_criteria =& new CriteriaCompo();
			$_criteria->add(new Criteria('perm_type', 1, '<='));
			$_criteria->add(new Criteria('discuss_id', '('. implode(",", $user_permitted_ids) .')', 'IN'), 'OR');
		}
		$criteria->add($_criteria);
		if (count($specified_ids) > 0) {
			$criteria->add(new Criteria('discuss_id', '('. implode(",", $specified_ids). ')', 'IN'));
		}
		return $this->getObjects($criteria, true);
	}
}
} // end of if
?>