<?php
/**
 * @version $Id$
 */
class DiscussGeneralRecord
{
    /**
     * @var array
     * @access private
     */
    var $vars;

    function DiscussGeneralRecord()
    {
        $this->vars = array();
    }

    /**
     * @param array $var_arr
     * @return void
     */
    function assignVars(&$var_arr)
    {
        $this->vars =& $var_arr;
    }

    /**
     * @param string $key
     * @return string
     */
    function get($key)
    {
        return $this->vars[$key];
    }
}

class DiscussGeneralModel
{
    /**
     * Database table name
     *
     * @var string
     * @access private
     */
    var $tableName;

    /**
     * @var XoopsDatabase
     * @access private
     */
    var $db;

    /**
     * @var string
     * @access private
     */
    var $record = 'DiscussGeneralRecord';

    /**
     * @var array
     * @access private
     */
    var $_errors;

    /**
     * @param XoopsDatabase $db
     */
    function DiscussGeneralModel()
    {
        $this->db =& XoopsDatabaseFactory::getDatabaseConnection();
        $this->_errors = array();
    }

    /**
     * @return string
     */
    function getErrors()
    {
        $error_str = "";
        if (count($this->_errors)) {
            $error_str = implode(',', $this->_errors);
        }
        return $error_str;
    }

    /**
     * @param array $context
     * @return DiscussGeneralRecord
     */
    function &get($context)
    {
        $sql = sprintf('SELECT * FROM `%s` WHERE %s',
             $this->db->prefix($this->tableName), $this->key2where($context));

        if ($result =& $this->query($sql)) {
            if ($myrow = $this->db->fetchArray($result)) {
                $class = $this->record;
                $record =& new $class();
                $record->assignVars($myrow);
                return $record;
            }
        }
        $ret = false;
        return $ret;
    }

    /**
     * @param array $context
     * @return string
     * @abstruct
     */
    function key2where($context)
    {
    }

    /**
     * @param DiscussView $view
     * @param string $where
     * @param int $param
     * @return bool
     */
    function assignObjects(&$view, $sql, $limit = 0, $start = 0)
    {
        if ($result =& $this->query($sql, $limit, $start)) {
            while ($myrow = $this->db->fetchArray($result)) {
                $view->assignVars($myrow);
            }
            return true;
        }
        return false;
    }

    function getCount($where)
    {
        $sql = sprintf('SELECT COUNT(*) FROM `%s` WHERE %s', $this->db->prefix($this->tableName), $where);

        $count = 0;
        if ($result =& $this->query($sql)) {
            list($count) = $this->db->fetchRow($result);
        }
        return $count;
    }

    /**
     * @return boolean
     */
    function update($sql)
    {
        $sql = sprintf('UPDATE `%s` SET %s', $this->db->prefix($this->tableName), $sql);
        return $this->query($sql);
    }

    /**
     * @return boolean
     */
    function insert($sql)
    {
        $sql = sprintf('INSERT INTO `%s` %s', $this->db->prefix($this->tableName), $sql);
        return $this->query($sql);
    }

    function &query($sql, $limit = 0, $start = 0)
    {
        $result =& $this->db->query($sql, $limit, $start);
        if (!$result) {
            $this->_errors[] = $this->db->error();
            $result = false;
        }
        return $result;
    }
}
?>