<?php
/**
 * @version $Id$
 */
class DiscussGeneralViewJson
{
	/**
	 * @var string
	 */
	var $_delim = '';

	/**
	 * @var string
	 */
	var $_result;

	/**
	 * @var string
	 */
	var $_end;

	/**
	 * @var array
	 */
	var $_vars;

	/**
	 * @var int
	 */
	var $_timeoffset;

	/**
	 * @var string
	 */
	var $_dateformat;

	function DiscussGeneralViewJson()
	{
		$this->_vars = array();
		$this->_result = '{';
		$this->_end = '}';
		$this->_delim = '';
		$this->initialize();
	}

	function initialize()
	{
	}

	/**
	 * @param string $key
	 * @param string $name
	 * @param string[optional] $func
	 * @param mixed
	 */
	function initVar($key, $name = null, $func = null)
	{
		$this->_vars[$key] = array('name' => $name, 'func' => $func);
	}

	/**
	 * @param string $key
	 * @param string $value
	 */
	function set($key, $value)
	{
		if (isset($this->_vars[$key])) {
			$name = isset($this->_vars[$key]['name']) ? $this->_vars[$key]['name'] : $key;
			$this->_result .= $this->_delim .'"'. $name .'":';

			if (isset($this->_vars[$key]['func'])) {
				$method = $this->_vars[$key]['func'];
				$this->_result .= $this->$method($value);
			} else {
				$this->_result .= $value;
			}
			$this->_delim = ',';
		}
	}

	/**
	 * @param string $string
	 * @return string
	 */
	function encodeString($string)
	{
		return $this->_encodeString($string);
	}

	/**
	 * @param int $dateformat
	 * @param int $timeoffset
	 */
	function setEnv($dateformat, $timeoffset = null)
	{
		if ($dateformat) {
			$this->_dateformat = $dateformat;
		}
		if (isset($timeoffset)) {
			$this->_timeoffset = $timeoffset;
		}
	}

	/**
	 * @param int $time
	 * @return string
	 */
	function encodeTimeStamp($time)
	{
		$timestamp = intval($time) + $this->_timeoffset * 3600;
		return $this->_encodeString(date($this->_dateformat, $timestamp));
	}

	function encodeBoolean($param)
	{
		if ($param) {
			return 'true';
		} else {
			return 'false';
		}
	}

	function encodeArray($arr)
	{
		$result = '[';
		$delim = '';
		foreach ($arr as $value) {
			$result .= $delim . '"' . $value . '"';
			$delim = ',';
		}
		$result .= ']';
		return $result;
	}

	/**
	 * @return void
	 */
	function render()
	{
		header('Content-type: application/json; charset=utf-8');
		echo $this->getEncoded();
//		header('X-JSON: ' . rawurlencode($this->getEncoded()));
	}

	/**
	 * return json string
	 *
	 * @return string
	 */
	function getResult() {
		return $this->_result . $this->_end;
	}

	/**
	 * return json string
	 *
	 * @return string
	 */
	function getEncoded() {
		return DiscussEncoder::toUtf8($this->getResult());
	}

	/**
	 * JSON encode a string value by escaping characters as necessary
	 *
	 * @copyright  Copyright (c) 2006 Zend Technologies USA Inc. (http://www.zend.com)
	 * @param string $string
	 * @return string
	 */
	function _encodeString($string)
	{
		// Escape these characters with a backslash:
		// " \ / \n \r \t \b \f
		$search  = array('\\', "\n", "\t", "\r", "\b", "\f", '"');
		$replace = array('\\\\', '\\n', '\\t', '\\r', '\\b', '\\f', '\"');
		$string  = str_replace($search, $replace, $string);

		// Escape certain ASCII characters:
		// 0x08 => \b
		// 0x0c => \f
		$string = str_replace(array(chr(0x08), chr(0x0C)), array('\b', '\f'), $string);

		return '"' . $string . '"';
	}
}
?>