<?php
/**
 * @version $Rev: 269 $
 * @link $URL: https://ajax-discuss.svn.sourceforge.net/svnroot/ajax-discuss/discuss/trunk/class/lib/session.php $
 */
class DiscussLibSession
{
	function start(&$config)
	{
		$_SESSION = array();

		if (ini_get('session.use_strict_mode')) {
            require_once XOOPS_ROOT_PATH . '/kernel/session.php';
            $sessionHandler =& new XoopsSessionHandler($db);
            session_set_save_handler(
			 array(&$sessionHandler, 'open'),
			 array(&$sessionHandler, 'close'),
			 array(&$sessionHandler, 'read'),
			 array(&$sessionHandler, 'write'),
			 array(&$sessionHandler, 'destroy'),
			 array(&$sessionHandler, 'gc')
            );
		}
		$allIniArray = ini_get_all();
		$lifetime = $allIniArray['session.cookie_lifetime']['global_value'];
		$sessionName = $allIniArray['session.name']['global_value'];

		if ($config['use_mysession']) {
			if ($config['session_name'] != '') {
				$sessionName = $config['session_name'];
				session_name($sessionName);
			}
			if (!empty($config['session_expire'])) {
				$lifetime = 60 * $config['session_expire'];
			}
		}

		require_once XOOPS_ROOT_PATH . '/include/version.php';
		if (substr(XOOPS_VERSION, 6, 4) == 'Cube') {
			$pathArray = parse_url(XOOPS_URL);
			$cookiePath = @$pathArray['path'].'/';
			session_set_cookie_params($lifetime, $cookiePath);
		} else {
			@ini_set('session.gc_maxlifetime', $lifetime);
		}
		session_start();

		if (!empty($lifetime) && isset($_COOKIE[$sessionName])) {
			// Refresh lifetime of Session Cookie
			setcookie($sessionName, session_id(), time() + $lifetime, $cookiePath);
		}
	}
}
?>