<?php
/**
 * discuss message log
 *
 * @version $Id$
 */
if (!class_exists('DiscussMessage')) {
require_once DISCUSS_PATH . '/class/general/xoopstableobject.php';

class DiscussMessage extends XoopsTableObject
{
	function DiscussMessage()
	{
		// call parent constructor
		$this->XoopsTableObject();

		// define object elements
		$this->initVar('discuss_id', XOBJ_DTYPE_INT, null, true);
		$this->initVar('message_id', XOBJ_DTYPE_INT, null, true);
		$this->initVar('uid', XOBJ_DTYPE_INT, null, true);
		$this->initVar('uname', XOBJ_DTYPE_TXTBOX, null, true, 60);
		$this->initVar('message', XOBJ_DTYPE_TXTAREA, null, true);
		$this->initVar('timestamp', XOBJ_DTYPE_INT, null, true);
		$this->initVar('color', XOBJ_DTYPE_INT, 0, false);
		$this->initVar('ip', XOBJ_DTYPE_TXTBOX, null, true, 15);

		// define primary key
		$this->setKeyFields(array('discuss_id','message_id'));
		$this->setAutoIncrementField('message_id');
	}
}

class DiscussMessageHandler extends XoopsTableObjectHandler
{
	/**
	 * database table name
	 *
	 * @var string
	 */
	var $tableName = 'discuss_message';

	/**
	 * @param int $discuss_id
	 * @param int $term
	 * @param int $limit
	 * @return array of DiscussMessage object
	 */
	function &getRecentMessages($discuss_id, $term, $limit)
	{
		$criteria =& new CriteriaCompo();
		$criteria->add(new Criteria('discuss_id', $discuss_id));
		if ($term > 0) {
			$criteria->add(new Criteria("timestamp", time() - $term, '>'));
		}
		$criteria->setLimit($limit);
		$criteria->setSort('message_id');
		$criteria->setOrder('DESC');

		return $this->getObjects($criteria);
	}

	function search($queryarray, $andor, $limit, $offset, $userid, $specified_ids = null)
	{
		$criteria =& new CriteriaCompo();
		$criteria->add(new Criteria('discuss_id', '('. implode(",", $specified_ids). ')', 'IN'));
		if ( is_array($queryarray) && ($count = count($queryarray)) ) {
			$criteria->add(new Criteria('message', "%".$queryarray[0]."%", 'LIKE'));
			for($i=1;$i<$count;$i++){
				$criteria->add(new Criteria('message', "%".$queryarray[$i]."%", 'LIKE'), $andor);
			}
		}
		if ($userid) {
			$criteria->add(new Criteria('uid', $userid));
		}
		$criteria->setLimit($limit);
		$criteria->setStart($offset);
		$criteria->setSort('timestamp');
		$criteria->setOrder('DESC');

		return $this->getObjects($criteria);
	}
}
}//end of if
?>
