<?php
/**
 * @version $Id$
 */
require_once DISCUSS_PATH . '/class/general/model.php';

class DiscussModelAttendee extends DiscussGeneralModel
{
    /**
     * Database table name
     *
     * @var string
     */
    var $tableName = 'discuss_attendee';

    /**
     * @param DiscussContext[reference] $context
     * @return string
     */
    function key2where(&$context)
    {
        $where = sprintf('`discuss_id`=%u AND `sess_id`=%s',
             $context->get('discuss_id'), $this->db->quoteString(session_id()));

        return $where;
    }

    /**
     * @param DiscussView[reference] $view
     * @param DiscussContext[reference] $context
     * @return bool
     */
    function assign(&$view, &$context)
    {
        $format = 'SELECT * FROM `%s` WHERE `discuss_id`=%u AND `updated`>=%u AND `status`>0';
        $sql = sprintf($format, $this->db->prefix($this->tableName),
            $context->get('discuss_id'), time() - DISCUSS_STAY_INTERVAL
            );
        return $this->assignObjects($view, $sql);
    }

    /**
     * @param DiscussContext[reference] $context
     * @param DiscussUser[reference] $user
     * @param int[optional] $status
     * @return boolean
     */
    function join(&$context, &$user, $status = 1)
    {
        $sess_id = $this->db->quoteString(session_id());

        $format = '`discuss_id`=%u AND `sess_id`=%s';
        $where = sprintf($format, $context->get('discuss_id'), $sess_id);

        if ($this->getCount($where)) {
            if ($status) {
                $format = '`uid`=%u, `uname`=%s, `updated`=%u, `status`=1, `timeoffset`=%u WHERE ';
            } else {
                $format = '`uid`=%u, `uname`=%s, `updated`=%u, `timeoffset`=%u WHERE ';
            }
            $sql = sprintf($format, $user->get('uid'),
                 $this->db->quoteString($user->get('uname')),
                 time(), $user->get('timeoffset')
                );
            return $this->update($sql . $where);
        } else {
            $format = '(`discuss_id`, `sess_id`, `uid`, `uname`, `updated`, `status`, `timeoffset`)';
            $format .= ' VALUES (%u, %s, %u, %s, %u, %u, %u)';
            $sql = sprintf($format, $context->get('discuss_id'),
                 $sess_id, $user->get('uid'),
                 $this->db->quoteString($user->get('uname')),
                 time(), $status, $user->get('timeoffset'));
            return $this->insert($sql);
        }
    }

    /**
     * update timestamp
     *
     * @param DiscussContext[reference] $context
     * @return boolean
     */
    function stay(&$context)
    {
        $format = '`updated`=%u WHERE `discuss_id`=%u AND `sess_id`=%s AND `updated`>=%u AND `status`>0';
        $sql = sprintf($format, time(), $context->get('discuss_id'),
                 $this->db->quoteString(session_id()),
                 time() - (DISCUSS_STAY_INTERVAL * 2)
                );
        return $this->update($sql);
    }

    /**
     * update timestamp
     *
     * @param DiscussContext[reference] $context
     * @return boolean
     */
    function renew(&$context)
    {
        $format = '`updated`=%u WHERE `discuss_id`=%u AND `sess_id`=%s AND `status`>0';
        $sql = sprintf($format, time(), $context->get('discuss_id'),
                 $this->db->quoteString(session_id())
                );
        return $this->update($sql);
    }

    /**
     * Set status 0
     *
     * @param DiscussContext[reference] $context
     * @return boolean
     */
    function leave($context)
    {
        $format = '`status`=0 WHERE `discuss_id`=%u AND `sess_id`=%s AND `status`>0';
        $sql = sprintf($format, $context->get('discuss_id'),
                 $this->db->quoteString(session_id())
                );
        return $this->update($sql);
    }

    /**
     * @param DiscussContext[reference] $context
     * @return DiscussGeneralRecord
     */
    function getActive(&$context)
    {
        $format = 'SELECT * FROM `%s` WHERE `discuss_id`=%u AND '
                . '`sess_id`=%s AND `updated`>=%u AND `status`>0';

        $sql = sprintf($format, $this->db->prefix($this->tableName)
                    , $context->get('discuss_id'), $this->db->quoteString(session_id())
                    , time() - (DISCUSS_STAY_INTERVAL * 2)
                    );

        $record = false;
        if ($result =& $this->query($sql)) {
            if ($myrow = $this->db->fetchArray($result)) {
                $record =& new DiscussGeneralRecord();
                $record->assignVars($myrow);
            }
        }
        return $record;
    }
}
?>