<?php
// $Id: discuss_blocks.php 93 2006-09-10 18:30:31Z yosha_01 $/
function b_discuss_active_discuss( $options )
{
	$message_lengs = isset($options[0]) ? intval($options[0]) : 0 ;
	$show_msg = isset($options[1]) ? intval($options[1]) : 60;
	
	$attendee_handler =& xoops_getmodulehandler("attendee", "discuss");
	$attendee_handler->garbageCollect(10);
	$criteria =& new CriteriaCompo(new Criteria("status", 1));
	$criteria->setSort('discuss_id');
	$attendee_objs = $attendee_handler->getObjects($criteria);
	if ( empty( $attendee_objs ) ) {
		return false;
	}
	
	$discuss_handler =& xoops_getmodulehandler("discuss", "discuss");
	if ($show_msg) {
		$ts =& MyTextSanitizer::getInstance();
		$msgobj_h =& xoops_getmodulehandler("message", "discuss");
		
		$module_name =  'discuss'  ;
		$hModule =& xoops_gethandler('module');
		$discussModule =& $hModule->getByDirname($module_name) ;
		if ( !is_object($discussModule) ) {
			return false;
		}
		$hModConfig =& xoops_gethandler('config');
		$module_id = $discussModule -> getVar( 'mid' );
		$discussConfig =& $hModConfig->getConfigsByCat(0, $module_id);
	}
	
	$block_outdata = array();
	foreach ($attendee_objs as $obj){
		$discuss_id = $obj->getVar('discuss_id');
		if (!isset($block_outdata[$discuss_id])) {
			$block_outdata[$discuss_id] = array();
			$discuss_obj =& $discuss_handler->get($discuss_id);
			if( !is_object($discuss_obj) ) continue;
			$block_outdata[$discuss_id]['subject'] = $discuss_obj->getvar('subject');
			if ($show_msg) {
				$criteria =& new CriteriaCompo();
				$criteria->add(new Criteria("discuss_id", $discuss_id));
				$criteria->add(new Criteria("timestamp", time() - $show_msg, '>'));
				$criteria->setLimit(1);
				$criteria->setSort('message_id');
				$criteria->setOrder('DESC');
				$msgobjs =& $msgobj_h->getObjects($criteria);
				if ( $msgobjs ) {
					if ( $message_lengs > 0 ) {
						$block_outdata[$discuss_id]['message'] = $ts->htmlSpecialChars(xoops_substr($msgobjs[0]->getVar('message' ,'none') , 0 , $message_lengs));
					} else {
						$block_outdata[$discuss_id]['message'] = '';
					}
					$block_outdata[$discuss_id]['message_id'] = $msgobjs[0]->getVar('message_id');
					$block_outdata[$discuss_id]['uid'] = $msgobjs[0]->getVar('uid');
					if (isset( $discussConfig['dateformat']) && trim( $discussConfig['dateformat'] ) != '' ){
						$block_outdata[$discuss_id]['timestamp'] = 	htmlspecialchars( formatTimestamp($msgobjs[0]->getVar('timestamp') , $discussConfig['dateformat'] ) .' ', ENT_QUOTES);
					} else {
						$block_outdata[$discuss_id]['timestamp'] = '';
					}
					$block_outdata[$discuss_id]['uname'] = $msgobjs[0]->getVar('uname');
				}
			}
			$block_outdata[$discuss_id]['unames'] = array();
		}
		if ( $obj->getVar('uid') > 0 ){
			$block_outdata[$discuss_id]['unames'][$obj->getVar('uid')] = $obj->getVar('uname');
		} else {
			$block_outdata[$discuss_id]['unames'][$obj->getVar('ip')] = $GLOBALS['xoopsConfig']['anonymous'];
		}
	}
	return $block_outdata;
}

function b_discuss_active_discuss_edit( $options )
{
	$message_length = isset($options[0]) ? intval($options[0]) : 0 ;
	$show_msg = isset($options[1]) ? intval($options[1]) : 60;
	
	$form = '<table width="100%">';
	$form .= '<tr><td width="40%">'. _MB_DISCUSS_MESSAGECHARS .':</td>';
	$form .= '<td><input type="text" name="options[0]" value="'. $message_length .'" /></td></tr>';
//	$form .= '<tr><td Colspan=2>'. _MB_DISCUSS_MESSAG_LENGTH .':</td></tr>';
	$form .= '<tr><td width="40%">'._MB_DISCUSS_EDIT_SHOWMSG.':</td>';
	$form .= '<td><input type="text" name="options[1]" value="'.$show_msg.'" /></td></tr>';
	$form .= '<tr><td Colspan=2>'._MB_DISCUSS_EDIT_SHOWMSGDSC.'</td></tr>';
	$form .= "</table>";
	return $form;
}
?>