<?php
// $Id: rss.php 59 2006-08-23 14:17:23Z yosha_01 $

require '../../mainfile.php';
require_once XOOPS_ROOT_PATH.'/class/template.php';

if (function_exists('mb_http_output')) {
    mb_http_output('pass');
}

// Load Local Encoder
if(file_exists(XOOPS_ROOT_PATH.'/modules/discuss/language/'.$GLOBALS['xoopsConfig']['language'].'/encoder.php')){
    require_once XOOPS_ROOT_PATH.'/modules/discuss/language/'.$GLOBALS['xoopsConfig']['language'].'/encoder.php';
} else {
    require_once XOOPS_ROOT_PATH.'/modules/discuss/class/encoder.php';	
}

$lifetime = 10;
$discuss_id = !empty($_GET["discuss_id"]) ? intval($_GET["discuss_id"]) : 0;

header('Content-type:text/xml; charset=utf-8');
$xoopsTpl = new XoopsTpl();
if( !is_object( $xoopsUser ) ) {
	$xoopsTpl->xoops_setCaching(2);
	$xoopsTpl->xoops_setCacheTime($lifetime);
} else {
	$xoopsTpl->xoops_setCaching(0);
	$xoopsTpl->xoops_setCacheTime(0);
}
if (!$xoopsTpl->is_cached('db:discuss_rss.html', $discuss_id)) {
	// discuss items
	$attendee_handler =& xoops_getmodulehandler("attendee", 'discuss');
	$attendee_handler->garbageCollect(5);
	$criteria =& new CriteriaCompo(new Criteria("status", 1));
	if ($discuss_id > 0) {
		$criteria->add(new Criteria('discuss_id', $discuss_id));
	} else {
		$criteria->setSort('discuss_id');
	}
	$attendee_objs = $attendee_handler->getObjects($criteria);
	if (!empty($attendee_objs)) {
		$discuss_handler =& xoops_getmodulehandler("discuss", 'discuss');
		$msgobj_h =& xoops_getmodulehandler("message", 'discuss');

		$items = array();
		foreach ($attendee_objs as $obj){
			$discuss_id = $obj->getVar('discuss_id');
			if (!isset($items[$discuss_id])) {
				$items[$discuss_id] = array();

				$discuss_obj =& $discuss_handler->get($discuss_id);
				if( !is_object($discuss_obj) ) continue;
				$items[$discuss_id]['subject'] = DiscussEncoder::toUtf8($discuss_obj->getvar('subject'));

				$criteria =& new CriteriaCompo(new Criteria("discuss_id", $discuss_id));
				$criteria->setLimit(1);
				$criteria->setSort('message_id');
				$criteria->setOrder('DESC');
				$msgobjs =& $msgobj_h->getObjects($criteria);
				if ( $msgobjs ) {
					$items[$discuss_id]['message'] = DiscussEncoder::toUtf8($msgobjs[0]->getVar('message'));
					$items[$discuss_id]['pubdate'] = formatTimestamp($msgobjs[0]->getVar('timestamp'), 'rss');
				}
				$items[$discuss_id]['unames'] = DiscussEncoder::toUtf8($obj->getVar('uname'));
			}
			else {
				$items[$discuss_id]['unames'] .= ','.DiscussEncoder::toUtf8($obj->getVar('uname'));
			}
		}

		// channel elements
		$xoopsTpl->assign('title', DiscussEncoder::toUtf8(htmlspecialchars($xoopsConfig['sitename'], ENT_QUOTES)));
		$xoopsTpl->assign('link', XOOPS_URL.'/modules/discuss/');
		$xoopsTpl->assign('description', 'Currently active discuss');
		$xoopsTpl->assign('last_build_date', formatTimestamp(time(), 'rss'));
		$xoopsTpl->assign('sitename', DiscussEncoder::toUtf8(htmlspecialchars($xoopsConfig['sitename'], ENT_QUOTES)));
		$xoopsTpl->assign('language', _LANGCODE);
		// items
		$xoopsTpl->assign('items', $items);
	}
}
$xoopsTpl->display('db:discuss_rss.html', $discuss_id);
?>