<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
$modversion['name'] = "Polaroid Gallery";
$modversion['version'] = 0.60;
$modversion['description'] = "Polaroid Gallery for XOOPS";
$modversion['author'] = 'beabo';
$modversion['credits'] = "Hiroki Seike<br />baseed <a href=\"http://www.no3dfx.com/polaroid/\"  target=\"_blank\">Polaroid Gallery</a>";
$modversion['help'] = "help.html";
$modversion['image'] = "images/pgallery.png";
$modversion['license'] = "Creative Commons Attribution-NonCommercial 3.0 License.";
$modversion['official'] = 0;
$modversion['dirname'] = "pgallery";

// XOOPS Cube Legacy
$modversion['cube_style'] = 1;

// SQL
if( defined( 'XOOPS_CUBE_LEGACY' ) ) {
    // XOOPS Cube Legacy
    // Tables created by sql file (without prefix!)
    $modversion['sqlfile']['mysql'] = "sql/mysql.sql";
    $modversion['tables'][0] = "{prefix}_{dirname}_gallery";
} else {
    // XOOPS 2.1.16a JP
    $modversion['sqlfile']['mysql'] = "sql/mysqlx2.sql";
    $modversion['tables'][0] = "pgallery_gallery";
}

// Admin page
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = "admin/index.php";
$modversion['adminmenu'] = "admin/menu.php";

// Menu
$modversion['hasMain'] = 1;
// Sub menu
$modversion['sub'] = array() ;
if( is_object( $GLOBALS['xoopsModule'] ) && $GLOBALS['xoopsModule']->getVar('dirname') == 'pgallery' ) {
    $db =& Database::getInstance() ;
    $sql = "SELECT tag FROM ". $db -> prefix("pgallery_gallery"). " ORDER BY weight ASC";
    $result = $db->query($sql);
    if( $result ) while( list( $tag ) = $db->fetchRow( $result ) ) {
        $url ="index.php?tag=".addSlashes($tag);
        $modversion['sub'][] = array('name' => addSlashes($tag), 'url'  => $url ) ;
    }
}

// Search
$modversion['hasSearch'] = 0;
// Smarty
$modversion['use_smarty'] = 1;
// Comments
$modversion['hasComments'] = 0;
// Notification
$modversion['hasNotification'] = 0;

// Templates
// Use your costom tag, you add templates.
$modversion['templates'][1]['file'] = 'pgallery_index.html';
$modversion['templates'][1]['description'] = 'Polaroid Gallery Index';
$modversion['templates'][2]['file'] = 'pgallery_view.html';
$modversion['templates'][2]['description'] = 'Polaroid Gallery Vew XML';

if( defined( 'XOOPS_CUBE_LEGACY' ) ) {
    // XOOPS Cube Legacy
    $modversion['config'][1]['name'] = 'flickerid';
    $modversion['config'][1]['title'] = _MI_PG_FLICKERID;
    $modversion['config'][1]['description'] = _MI_PG_FLICKERIDDSC;
    $modversion['config'][1]['formtype'] ='textbox';
    $modversion['config'][1]['valuetype'] = 'text';
    $modversion['config'][1]['default'] ='Your flickr ID';
    $modversion['config'][2]['name'] = 'deftag';
    $modversion['config'][2]['title'] = _MI_PG_DEFTAG;
    $modversion['config'][2]['description'] = _MI_PG_DEFTAGDSC;
    $modversion['config'][2]['formtype'] = 'textbox';
    $modversion['config'][2]['valuetype'] = 'text';
    $modversion['config'][2]['default'] ='';
} else {
    // XOOPS 2.1.16a JP
    $modversion['config'][1]['name'] = 'flickerid';
    $modversion['config'][1]['title'] = '_MI_PG_FLICKERID';
    $modversion['config'][1]['description'] = '_MI_PG_FLICKERIDDSC';
    $modversion['config'][1]['formtype'] ='textbox';
    $modversion['config'][1]['valuetype'] = 'text';
    $modversion['config'][1]['default'] ='Your flickr ID';
    $modversion['config'][2]['name'] = 'deftag';
    $modversion['config'][2]['title'] = '_MI_PG_DEFTAG';
    $modversion['config'][2]['description'] = '_MI_PG_DEFTAGDSC';
    $modversion['config'][2]['formtype'] = 'textbox';
    $modversion['config'][2]['valuetype'] = 'text';
    $modversion['config'][2]['default'] ='';
}

?>