<?php
/***********************************************************************************
 * MVC ( Model View Control ) Action Program
 ******************************** License: GPLv3 ********************************
 * Copyright (C) 2011 Yoshi Sakai (A.K.A. bluemooninc)
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ***********************************************************************************/
require '../../mainfile.php';
include XOOPS_ROOT_PATH."/header.php";
/***********************************************************************************
 * Model Section
 ***********************************************************************************/
$mydirname = basename( dirname( __FILE__ ) ) ;
$mymodpath = XOOPS_ROOT_PATH."/modules/$mydirname" ;
$model = isset($_GET['model']) ? htmlspecialchars($_GET['model'],ENT_QUOTES) : "searchform";
$model = isset($_POST['model']) ? htmlspecialchars($_POST['model'],ENT_QUOTES) : $model;
$ctrl = isset($_GET['ctrl']) ? $model . "_" . htmlspecialchars($_GET['ctrl'],ENT_QUOTES) : "";
$ctrl = isset($_POST['ctrl']) ? $model . "_" . htmlspecialchars($_POST['ctrl'],ENT_QUOTES) : $ctrl;
$myclass = $mymodpath . "/class/" . $model . ".php";
require( $myclass );
$handler = new ActionHandler($ctrl);
if ( !$ret = $handler->load() ){
    echo $handler->debug(); die;
}
/***********************************************************************************
 * Ctrl Section
 ***********************************************************************************/
if ( $ctrl ){
    if ( !$ret = $handler->$ctrl() ){
        echo $handler->debug(); die;
    }
}
/***********************************************************************************
 * View Section
 ***********************************************************************************/
$handler->assignRecords();
$xoopsOption['template_main'] = $mydirname . "_" . $model . ".html" ;
include( XOOPS_ROOT_PATH.'/footer.php' ) ;
?>