#ifdef	QWS

#include <qapplication.h>
#include <qdirectpainter_qws.h>
#include <qimage.h>

#include "xqtcpp.h"

bool qtDirectPaint0(QDirectPainter *p, QImage *img, const QRect &rect)
{
	uchar *fb = p->frameBuffer();
	uchar *ib = img->bits();

	int fb_step = p->lineStep();
	int ib_step = img->bytesPerLine();

	ib += rect.left() * 2 + rect.top() * ib_step;
	fb += (p->xOffset() + rect.left()) * 2 +
		(p->yOffset() + rect.top()) * fb_step;

	int w = rect.width() * 2;
	int h = rect.height();

	while (h--) {
		memcpy(fb, ib, w);
		fb += fb_step;
		ib += ib_step;
	}

	return TRUE;
}

// 270 rotation : SL-C7xx, 8xx, 5500 etc.
bool qtDirectPaint3(QDirectPainter *p, QImage *img, const QRect &rect)
{
	uchar *fb = p->frameBuffer();
	uchar *ib = img->bits();

	int fb_step = p->lineStep();
	int ib_step = img->bytesPerLine();

	ib += rect.left() * 2 + rect.top() * ib_step;

	fb += (QApplication::desktop()->height() - p->yOffset() - rect.top()) * 2 +
		(p->xOffset() + rect.left()) * fb_step;

	int h = rect.height();

	uchar *fb_next;
	uchar *ib_next;

	while (h--) {
		ib_next = ib + ib_step;
		fb_next = fb - 2;

		int w = rect.width();
		while (w--) {
			*(ushort *)fb = *(ushort *)ib;
			ib += 2;
			fb += fb_step;
		}

		ib = ib_next;
		fb = fb_next;
	}

	return TRUE;
}

#endif	// QWS
