package org.kaoriha.jspbp.renderer.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.jdom.Content;
import org.jdom.Element;
import org.kaoriha.jspbp.renderer.AbstractRenderer;
import org.kaoriha.jspbp.renderer.AbstractRootRenderer;
import org.kaoriha.jspbp.renderer.ViewState;

public class Table<ColT extends Enum<ColT>, CellT> extends
		AbstractRootRenderer<Source<ColT, CellT>> {

	public Table(ViewState viewState) {
		super(viewState);
	}

	private AbstractRenderer<CellT> caption = new SimpleRenderer<CellT>(
			viewState);
	private Thead<ColT, CellT> thead = new Thead<ColT, CellT>(viewState);
	private Tbody<ColT, CellT> tbody = new Tbody<ColT, CellT>(viewState);
	private Tfoot<ColT, CellT> tfoot = new Tfoot<ColT, CellT>(viewState);
	private Scroller<ColT, CellT> scroller = new Scroller<ColT, CellT>(
			viewState);

	@Override
	public List<Content> render() {
		Query<ColT> q = new Query<ColT>();

		if (viewState.getQueryMap().containsKey(Constant.QN_SORT)) {
			List<Sort<ColT>> sortList = new ArrayList<Sort<ColT>>();
			for (String s : viewState.getQueryMap().get(Constant.QN_SORT)) {
				boolean isAsc;
				if (s.charAt(0) == Constant.PRE_ASC) {
					isAsc = true;
				} else if (s.charAt(0) == Constant.PRE_DSC) {
					isAsc = false;
				} else {
					continue;
				}
				sortList.add(new Sort<ColT>(source.valueOfEnum(s.substring(1)),
						isAsc));
			}
			q.setSortList(sortList);
		}

		if (viewState.getQueryMap().containsKey(Constant.QN_OFFSET)) {
			try {
				int offset = Integer.parseInt(viewState.getQueryMap().get(
						Constant.QN_OFFSET).get(0));
				q.setOffset(offset);
			} catch (Exception e) {
			}
		}

		if (viewState.getQueryMap().containsKey(Constant.QN_LIMIT)) {
			try {
				int size = Integer.parseInt(viewState.getQueryMap().get(
						Constant.QN_LIMIT).get(0));
				q.setSize(size);
			} catch (Exception e) {
			}
		} else {
			q.setSize(Default.PAGE_WIDTH);
		}

		Data<ColT, CellT> data = source.getData(q);

		Element table = new Element("table");

		if (data.getCaption() != null) {
			Element ce = new Element("caption");
			table.addContent(ce);
			caption.setSource(data.getCaption());
			caption.render(ce);
		}

		if (data.getHeader() != null) {
			thead.setSource(data);
			thead.render(table);
		}

		if (data.getCell() != null) {
			tbody.setSource(data);
			tbody.render(table);
		}

		if (data.getFooter() != null) {
			tfoot.setSource(data);
			tfoot.render(table);
		}

		scroller.setSource(data);
		List<Content> s = scroller.render();

		if (s == null) {
			return Arrays.asList((Content)table);
		} else {
			List<Content> ret = new ArrayList<Content>();
			ret.add(table);
			ret.addAll(s);
			return ret;
		}
	}

	public Thead<ColT, CellT> getThead() {
		return thead;
	}

	public void setThead(Thead<ColT, CellT> thead) {
		this.thead = thead;
	}

	public Tbody<ColT, CellT> getTbody() {
		return tbody;
	}

	public void setTbody(Tbody<ColT, CellT> tbody) {
		this.tbody = tbody;
	}

	public Tfoot<ColT, CellT> getTfoot() {
		return tfoot;
	}

	public void setTfoot(Tfoot<ColT, CellT> tfoot) {
		this.tfoot = tfoot;
	}

	public AbstractRenderer<CellT> getCaption() {
		return caption;
	}

	public void setCaption(AbstractRenderer<CellT> caption) {
		this.caption = caption;
	}

	public void setScroller(Scroller<ColT, CellT> scroller) {
		this.scroller = scroller;
	}

	public Scroller<ColT, CellT> getScroller() {
		return scroller;
	}
}
