#!/usr/bin/ruby

require 'fusefs'

require "svn/fs"
require "svn/core"
require "svn/repos"


class SvnRepo
  def initialize(path)
    @repos_path = path
    #@path = "/"
    #self.rev = youngest_rev
    #@exited = false
  end

  def youngest_rev
    return Svn::Repos.open(@repos_path).fs.youngest_rev
  end

  def lsdirpath(rev, path)
    fs = Svn::Repos.open(@repos_path).fs
    root = fs.root(rev)
    return root.dir_entries(path)
  end

  def file?(rev, path)
    fs = Svn::Repos.open(@repos_path).fs
    root = fs.root(rev)
    return root.check_path(path) == Svn::Core::NODE_FILE
  end
  def directory?(rev, path)
    fs = Svn::Repos.open(@repos_path).fs
    root = fs.root(rev)
    return root.check_path(path) == Svn::Core::NODE_DIR
  end

  def cat(rev, path)
    fs = Svn::Repos.open(@repos_path).fs
    root = fs.root(rev)
    # Output the file
    root.file_contents(path) do |stream|
      return stream.read(root.file_length(path))
    end
  end
end

# Top dir
class RepoDir
  def initialize(srepo)
    @svnrepo = srepo

    @revs = []
    youngnum =@svnrepo.youngest_rev
    for i in 1..youngnum do
      @revs << "r" + i.to_s
    end
  end
  def contents(path)
    p path
    if path == '/'
      return @revs
    else
      printf("rev:%d path:%s\n", getSvnRev(path), getSvnPath(path))
      tmp = @svnrepo.lsdirpath(getSvnRev(path), getSvnPath(path))
      # tmp is hash.
      return tmp.keys
    end
  end
  def file?(path)
    return @svnrepo.file?(getSvnRev(path), getSvnPath(path))
  end
  def directory?(path)
    for i in @revs do
      if path == "/"+i
        return true
      end
    end
    return @svnrepo.directory?(getSvnRev(path), getSvnPath(path))
  end
  def read_file(path)
    # return "Hello, World!\n"
    return @svnrepo.cat(getSvnRev(path), getSvnPath(path))
  end

  def getSvnRev(path)
    tmp = path.split(/\//)
    tmp_rNN = tmp[1]
    return tmp_rNN.slice(1..tmp_rNN.length).to_i
  end
  
  def getSvnPath(path)
    index = path.index("\/", 1)
    if index == nil
      return "/"
    end
    return path.slice(index, path.length)
  end
end

# main #########
printf("Start....\n")
#for svn
svnrepo = SvnRepo.new(ARGV.shift)

# for FuseFS
repodir = RepoDir.new(svnrepo)
FuseFS.set_root( repodir )

# Mount under a directory given on the command line.
FuseFS.mount_under ARGV.shift
FuseFS.run
