/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.factory;

import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.monitor.ejb.entity.EventMultiInfoLocal;
import com.clustercontrol.monitor.ejb.entity.EventMultiInfoPK;
import com.clustercontrol.monitor.ejb.entity.EventMultiInfoUtil;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputEventLog {
    protected static Log m_log = LogFactory.getLog(OutputEventLog.class);
    private LogOutputInfo m_logOutput = null;
    private Timestamp m_outputDate = null;
    private boolean m_insertFlg;
    private boolean m_insertMultiFlg;
    private boolean m_updateFlg;
    private boolean m_updateMultiFlg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean outputEventLog(LogOutputInfo logOutput, Timestamp outputDate) {
        this.m_logOutput = logOutput;
        this.m_outputDate = outputDate;
        this.m_insertFlg = false;
        this.m_insertMultiFlg = false;
        this.m_updateFlg = false;
        this.m_updateMultiFlg = false;
        boolean result = false;
        if (logOutput.isEventLogFlg()) {
            Timestamp outputDateMulti;
            String multiId;
            EventMultiInfoLocal eventMultiInfo;
            EventLogLocal eventLog;
            block66: {
                Iterator itr;
                Collection coll = null;
                Object collMulti = null;
                eventLog = null;
                eventMultiInfo = null;
                multiId = logOutput.getMultiId();
                outputDateMulti = null;
                if (logOutput.getExcludeFlg() == 1 || logOutput.getExcludeFlg() == 2 || logOutput.getExcludeFlg() == 3) {
                    try {
                        coll = EventLogUtil.getLocalHome().findByGenerationDateOrder(logOutput.getMonitorId(), logOutput.getPluginId(), logOutput.getFacilityId(), new Timestamp(logOutput.getGenerationDate().getTime()), new Integer(0));
                        itr = coll.iterator();
                        if (itr.hasNext()) {
                            eventLog = (EventLogLocal)itr.next();
                            if (multiId == null) {
                                if (this.isInhibited(logOutput, eventLog)) {
                                    this.m_updateFlg = true;
                                } else {
                                    this.m_insertFlg = true;
                                }
                                break block66;
                            }
                            try {
                                eventMultiInfo = EventMultiInfoUtil.getLocalHome().findByPrimaryKey(new EventMultiInfoPK(eventLog.getMonitorId(), eventLog.getPluginId(), eventLog.getFacilityId(), eventLog.getOutputDate(), logOutput.getMultiId()));
                                if (eventMultiInfo != null) {
                                    if (eventLog.getDuplicationCount() > eventMultiInfo.getDuplicationCount()) {
                                        this.m_updateMultiFlg = true;
                                    } else if (this.isInhibited(logOutput, eventLog)) {
                                        this.m_updateFlg = true;
                                        this.m_updateMultiFlg = true;
                                    } else {
                                        this.m_insertFlg = true;
                                        this.m_insertMultiFlg = true;
                                    }
                                    break block66;
                                }
                                this.m_insertMultiFlg = true;
                                outputDateMulti = eventLog.getOutputDate();
                            }
                            catch (FinderException e) {
                                this.m_insertMultiFlg = true;
                                outputDateMulti = eventLog.getOutputDate();
                            }
                            break block66;
                        }
                        this.m_insertFlg = true;
                        if (multiId != null) {
                            this.m_insertMultiFlg = true;
                        }
                    }
                    catch (NamingException e) {
                        m_log.error((Object)("outputEventLog():" + e.getMessage()));
                    }
                    catch (FinderException e) {}
                } else if (multiId == null) {
                    this.m_insertFlg = true;
                } else {
                    try {
                        coll = EventLogUtil.getLocalHome().findByMessageOrg(logOutput.getMonitorId(), logOutput.getPluginId(), logOutput.getFacilityId(), new Timestamp(logOutput.getGenerationDate().getTime()), logOutput.getMessageOrg());
                        itr = coll.iterator();
                        if (itr.hasNext()) {
                            while (itr.hasNext()) {
                                eventLog = (EventLogLocal)itr.next();
                                try {
                                    eventMultiInfo = EventMultiInfoUtil.getLocalHome().findByPrimaryKey(new EventMultiInfoPK(eventLog.getMonitorId(), eventLog.getPluginId(), eventLog.getFacilityId(), eventLog.getOutputDate(), logOutput.getMultiId()));
                                }
                                catch (FinderException e) {
                                    outputDateMulti = eventLog.getOutputDate();
                                    break;
                                }
                            }
                            if (outputDateMulti == null) {
                                this.m_insertFlg = true;
                                this.m_insertMultiFlg = true;
                            } else {
                                this.m_insertMultiFlg = true;
                            }
                        } else {
                            this.m_insertFlg = true;
                            this.m_insertMultiFlg = true;
                        }
                    }
                    catch (NamingException e) {
                        m_log.error((Object)("outputEventLog():" + e.getMessage()));
                    }
                    catch (FinderException e) {
                        // empty catch block
                    }
                }
            }
            try {
                if (this.m_insertFlg) {
                    this.insertEventLog(logOutput, 0);
                    if (logOutput.getJobRun() != null && logOutput.getJobRun().getJobRun() == 1) {
                        SendQueue queue = null;
                        try {
                            queue = new SendQueue("queue/clustercontrol/Monitor/RunJob");
                            queue.put((Serializable)logOutput);
                        }
                        catch (Exception e) {
                            m_log.debug((Object)("outputEventLog() : \u30b8\u30e7\u30d6\u5b9f\u884c\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                        }
                        finally {
                            if (queue != null) {
                                try {
                                    queue.terminate();
                                }
                                catch (JMSException e) {}
                            }
                        }
                    }
                }
                if (this.m_updateFlg) {
                    this.updateEventLog(eventLog);
                    if (logOutput.getExcludeConfirmFlg() == 1 || logOutput.getExcludeConfirmFlg() == 0) {
                        this.insertEventLog(logOutput, 1);
                        LogOutputJobRunInfo jobRunInfo = logOutput.getJobRun();
                        if (jobRunInfo != null && jobRunInfo.getJobRun() == 1 && jobRunInfo.getJobInhibitionFlg() == 0) {
                            SendQueue queue = null;
                            try {
                                queue = new SendQueue("queue/clustercontrol/Monitor/RunJob");
                                queue.put((Serializable)logOutput);
                            }
                            catch (Exception e) {
                                m_log.debug((Object)("outputEventLog() : \u30b8\u30e7\u30d6\u5b9f\u884c\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                            }
                            finally {
                                try {
                                    queue.terminate();
                                }
                                catch (JMSException e) {}
                            }
                        }
                    }
                }
                if (multiId != null) {
                    if (this.m_insertMultiFlg) {
                        if (outputDateMulti == null) {
                            outputDateMulti = this.m_outputDate;
                        }
                        this.insertEventMultiInfo(logOutput, outputDateMulti);
                    }
                    if (this.m_updateMultiFlg) {
                        this.updateEventMultiInfo(eventMultiInfo);
                    }
                }
                result = true;
            }
            catch (NamingException e) {
                m_log.error((Object)("outputEventLog():" + e.getMessage()));
            }
            catch (CreateException e) {
                m_log.error((Object)("outputEventLog():" + e.getMessage()));
            }
            catch (EJBException e) {
                m_log.error((Object)("outputEventLog():" + e.getMessage()));
            }
        }
        return result;
    }

    public void insertEventLog(LogOutputInfo logOutput, int inhibitedFlg) throws NamingException, CreateException {
        try {
            int confirmFlg = -1;
            confirmFlg = inhibitedFlg == 1 ? logOutput.getExcludeConfirmFlg() : logOutput.getConfirmFlg();
            EventLogUtil.getLocalHome().create(logOutput.getMonitorId(), logOutput.getPluginId(), logOutput.getFacilityId(), logOutput.getScopeText(), logOutput.getApplication(), logOutput.getMessageId(), logOutput.getMessage(), logOutput.getMessageOrg(), new Integer(logOutput.getPriority()), new Integer(confirmFlg), null, new Integer(0), new Timestamp(logOutput.getGenerationDate().getTime()), this.m_outputDate, new Integer(inhibitedFlg));
        }
        catch (NamingException e) {
            throw e;
        }
        catch (CreateException e) {
            if (e instanceof DuplicateKeyException) {
                Date now = new Date();
                this.m_outputDate = new Timestamp(now.getTime());
                this.insertEventLog(logOutput, inhibitedFlg);
            }
            throw e;
        }
    }

    public void insertEventMultiInfo(LogOutputInfo logOutput, Timestamp outputDate) throws NamingException, CreateException {
        try {
            EventMultiInfoUtil.getLocalHome().create(logOutput.getMonitorId(), logOutput.getPluginId(), logOutput.getFacilityId(), outputDate, logOutput.getMultiId(), 0);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (CreateException e) {
            throw e;
        }
    }

    public void updateEventLog(EventLogLocal eventLog) throws EJBException {
        if (eventLog != null) {
            eventLog.setDuplicationCount(new Integer(eventLog.getDuplicationCount() + 1));
        }
    }

    public void updateEventMultiInfo(EventMultiInfoLocal EventMultiInfo2) throws EJBException {
        if (EventMultiInfo2 != null) {
            EventMultiInfo2.setDuplicationCount(new Integer(EventMultiInfo2.getDuplicationCount() + 1));
        }
    }

    public boolean isInhibited(LogOutputInfo logOutput, EventLogLocal eventLog) {
        if (logOutput.getExcludeFlg() == 1 && eventLog.getConfirmDate() == null) {
            if (eventLog.getDuplicationCount() < logOutput.getExcludeNumber()) {
                return true;
            }
        } else if (logOutput.getExcludeFlg() == 2 && eventLog.getConfirmDate() == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(eventLog.getGenerationDate());
            cal.add(12, logOutput.getExcludePeriod());
            if (cal.getTime().compareTo(logOutput.getGenerationDate()) > 0) {
                return true;
            }
        } else if (logOutput.getExcludeFlg() == 3 && eventLog.getConfirmDate() == null && eventLog.getPriority().intValue() == logOutput.getPriority()) {
            return true;
        }
        return false;
    }

    public Timestamp getOutputDate() {
        return this.m_outputDate;
    }

    public void setOutputDate(Timestamp outputDate) {
        this.m_outputDate = outputDate;
    }

    public boolean isInsertFlg() {
        return this.m_insertFlg;
    }
}

