// Input.cpp

#include <DxLib.h>
#include "define.h"
#include "Input.h"

// ͏ԕێpϐ
int Input, EdgeInput;

////////////////////////////////////////////////////////////////////////////////
// ͏Ԃ̏
////////////////////////////////////////////////////////////////////////////////
void InitInput(void)
{
    Input = 0;
    EdgeInput = 0;
}

////////////////////////////////////////////////////////////////////////////////
// ͏Ԃ̎擾
////////////////////////////////////////////////////////////////////////////////
void GetInput(void)
{
    int i = GetJoypadInputState(DX_INPUT_KEY_PAD1);
    EdgeInput = i & ~Input;
    Input = i;
}

////////////////////////////////////////////////////////////////////////////////
// fobOp
////////////////////////////////////////////////////////////////////////////////
#ifdef DEBUG_MODE
void InputDebug(void)
{
    printfDx("Input: ");
    printfDx("0x%x\n", Input);
    if (PUSH_UP)
        printfDx(" ");
    if (PUSH_LEFT)
        printfDx(" ");
    if (PUSH_DOWN)
        printfDx(" ");
    if (PUSH_RIGHT)
        printfDx(" ");
    if (PUSH_RIGHT | PUSH_UP | PUSH_DOWN | PUSH_LEFT)
        printfDx("\n");

    if (Input & PAD_INPUT_A)
        printfDx("A(Z) ");
    if (Input & PAD_INPUT_B)
        printfDx("B(X) ");
    if (Input & PAD_INPUT_C)
        printfDx("C(C) ");
    printfDx("\n");
}
#endif

