// Player.cpp

#include <DxLib.h>
#include "define.h"
#include "Input.h"
#include "Player.h"

////////////////////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////////////////////
int PlayerInit(PLAYER &src, char *filename)
{
    int hBuf = LoadGraph(filename);
    if (hBuf == -1)
        return -1;
    GetGraphSize(hBuf, &(src.w), &(src.h));
    src.w /= GRAPH_X;
    src.h /= GRAPH_Y;
    src.x = 32;
    src.y = 32;
    src.sx = 32;
    src.sy = 32;
    /*
    src.x = (SCREEN_WIDTH-src.w)/2;
    src.y = (SCREEN_HEIGHT-src.h)/2;
    src.sx = (SCREEN_WIDTH-src.w)/2;
    src.sy = (SCREEN_HEIGHT-src.h)/2;
    */
    src.walk = 0;
    src.vWalk = 1;
    src.vRun = 2;
    src.dir = D_DOWN;
    src.frame = 0;

    LoadDivGraph(filename, GRAPH_MAX, GRAPH_X, GRAPH_Y, src.w, src.h, src.hGraph);

    return 0;
}

////////////////////////////////////////////////////////////////////////////////
// C
////////////////////////////////////////////////////////////////////////////////
void PlayerMain(PLAYER &src, MAP &map)
{
    // W̃obNAbv
    int x = src.x, y = src.y;
    int sx = src.sx, sy = src.sy;

    // ړx
    int v, vx = 0, vy = 0;

    // ړx̐ݒ
    if (Input & PAD_INPUT_B)
        src.walk = 1;
    else
        src.walk = 0;
    if (src.walk == 0)
        v = src.vWalk;
    else
        v = src.vRun;

    // \L[AJ[\L[Ăꍇ
    if (PUSH_UP | PUSH_RIGHT | PUSH_LEFT | PUSH_DOWN) {
        if (PUSH_DOWN) {
            src.dir = D_DOWN;
            vy = v;
        }
        if (PUSH_LEFT) {
            src.dir = D_LEFT;
            vx = -v;
        }
        if (PUSH_RIGHT) {
            src.dir = D_RIGHT;
            vx = v;
        }
        if (PUSH_UP) {
            src.dir = D_UP;
            vy = -v;
        }
        if (count % 8 == 0)
            src.frame++;
        if (src.frame == 4)
            src.frame = 0;
        src.y += vy;
        src.x += vx;
        if (src.x < (SCREEN_WIDTH-src.w)/2 || src.x > map.w-(SCREEN_WIDTH+src.w)/2)
            src.sx += vx;
        else {
            map.x = -src.x + (SCREEN_WIDTH-src.w) / 2;
        }
        if (src.y < (SCREEN_HEIGHT-src.h)/2 || src.y > map.h-(SCREEN_HEIGHT+src.h)/2)
            src.sy += vy;
        else {
            map.y = -src.y + (SCREEN_HEIGHT-src.h) / 2;
        }
        PlayerMoveLimit(src, map, sx, sy, x, y, v);

        // ړ}XNɂړ␳
        int nColor[4];
        int nNotMoveColor = GetColor(0,0,0);
        nColor[POS_UL] = GetPixel(src.sx,       src.sy+src.h*3/4);
        nColor[POS_UR] = GetPixel(src.sx+src.w, src.sy+src.h*3/4);
        nColor[POS_DL] = GetPixel(src.sx,       src.sy+src.h);
        nColor[POS_DR] = GetPixel(src.sx+src.w, src.sy+src.h);
        if (PUSH_DOWN) {
            if (!(nColor[POS_DL] == nNotMoveColor && nColor[POS_DR] == nNotMoveColor)) {
                if (nColor[POS_DL] == nNotMoveColor)
                    vx = v;
                else if (nColor[POS_DR] == nNotMoveColor)
                    vx = -v;
            } else {
                vy = 0;
            }
        }
        if (PUSH_LEFT) {
            if (!(nColor[POS_UL] == nNotMoveColor && nColor[POS_DL] == nNotMoveColor)) {
                if (nColor[POS_UL] == nNotMoveColor)
                    vy = v;
                else if (nColor[POS_DL] == nNotMoveColor)
                    vy = -v;
            } else {
                vx = 0;
            }
        }
        if (PUSH_RIGHT) {
            if (!(nColor[POS_UR] == nNotMoveColor && nColor[POS_DR] == nNotMoveColor)) {
                if (nColor[POS_UR] == nNotMoveColor)
                    vy = v;
                else if (nColor[POS_DR] == nNotMoveColor)
                    vy = -v;
            } else {
                vx = 0;
            }
        }
        if (PUSH_UP) {
            if (!(nColor[POS_UL] == nNotMoveColor && nColor[POS_UR] == nNotMoveColor)) {
                if (nColor[POS_UL] == nNotMoveColor)
                    vx = v;
                else if (nColor[POS_UR] == nNotMoveColor)
                    vx = -v;
            } else {
                vy = 0;
            }
        }
            PlayerMoveCheck(src, sx, sy, x, y);
        src.x += vx;
        src.y += vy;
        if (src.x < (SCREEN_WIDTH-src.w)/2 || src.x > map.w-(SCREEN_WIDTH+src.w)/2)
            src.sx += vx;
        else {
            map.x = -src.x + (SCREEN_WIDTH-src.w) / 2;
        }
        if (src.y < (SCREEN_HEIGHT-src.h)/2 || src.y > map.h-(SCREEN_HEIGHT+src.h)/2)
            src.sy += vy;
        else {
            map.y = -src.y + (SCREEN_HEIGHT-src.h) / 2;
        }
        PlayerMoveLimit(src, map, sx, sy, x, y, v);
    }
    else {
        src.frame = 0;
    }
}

////////////////////////////////////////////////////////////////////////////////
// `
////////////////////////////////////////////////////////////////////////////////
void PlayerDraw(PLAYER src)
{
    DrawGraph(src.sx, src.sy, src.hGraph[src.dir*GRAPH_X+src.frame], true);
}

////////////////////////////////////////////////////////////////////////////////
// ړ`FbN
////////////////////////////////////////////////////////////////////////////////
int PlayerMoveCheck(PLAYER &src, int sx, int sy, int x, int y)
{
    // ړ}XNňړ
    int nColor[4];
    int nNotMoveColor = GetColor(0,0,0);
    nColor[POS_UL] = GetPixel(src.sx,       src.sy+src.h*3/4);
    nColor[POS_UR] = GetPixel(src.sx+src.w, src.sy+src.h*3/4);
    nColor[POS_DL] = GetPixel(src.sx,       src.sy+src.h);
    nColor[POS_DR] = GetPixel(src.sx+src.w, src.sy+src.h);

    for (int i = 0; i < 4; i++) {
        if (nColor[i] == nNotMoveColor) {
            src.sx = sx;
            src.sy = sy;
            src.x = x;
            src.y = y;
            return 1;
        }
    }
    return 0;
}

////////////////////////////////////////////////////////////////////////////////
// ړ
////////////////////////////////////////////////////////////////////////////////
void PlayerMoveLimit(PLAYER &src, MAP map, int sx, int sy, int x, int y, int v)
{
    // ʓړ
    if (src.sx < v)
        src.sx = sx;
    if (src.sy < v)
        src.sy = sy;
    if (src.sx > SCREEN_WIDTH-src.w-v)
        src.sx = sx;
    if (src.sy > SCREEN_HEIGHT-src.h-v)
        src.sy = sy;
    // }bvړ
    if (src.x < v)
        src.x = x;
    if (src.y < v)
        src.y = y;
    if (src.x > map.w-src.w-v)
        src.x = x;
    if (src.y > map.h-src.h-v)
        src.y = y;
}


////////////////////////////////////////////////////////////////////////////////
// fobOp
////////////////////////////////////////////////////////////////////////////////
#ifdef DEBUG_MODE
void PlayerDebug(PLAYER src)
{
    char str[64];
    sprintf(str, "[%d,%d]", src.x, src.y);
    DebugPrintCenter(src.sx, src.sy+src.h, src.w, str);
}
#endif

