# vim fileencoding=utf-8
# vi:ts=4:et
#
# $Date: 2004/04/25 16:54:51 $
# $Revision: 1.4 $
# =====================================================
"""sample programs for combination.py"""

from young import *
import itertools

def factorial_demo():
    """demo of factorial"""
    print factorial_demo.__doc__
    print

    print "factorial(5) = ", factorial(5)
    print

    print "3 x 4 x 5    = ", factorial(3,5)
    print

def permutation_demo():
    """demo of permutation"""
    print permutation_demo.__doc__
    print

    print "permutation of [1,2,3]"
    print permutation(1,2,3)
    # permutation([1,2,3])
    # is also a valid expression.
    print

    print "permutation of 'xyz'"
    print permutation('xyz')
    print


def combination_demo():
    """demo of combination"""
    print combination_demo.__doc__
    print

    print "take 2 elements from 4"
    print combination(4, 2)
    print

    print "take 2 letters from 'python'"
    print combination('python', 2)
    print


def catalan_demo():
    """demo of Catalan"""
    print catalan_demo.__doc__
    print

    print "catalan(20)"
    print catalan(20)
    print

    print "Catalan number from 0 to 9"
    for i in range(10):
        print i, catalan(i)
    print

    # generator-based Catalan number
    print "Show Catalan number from 0 to 9 using a generator"
    for num in itertools.islice(catalan_generator(), 10):
        print num
    print 

def composition_demo():
    """demo of composition"""
    print composition_demo.__doc__
    print

    n = 8
    for i in range(1, 5):
        print "composition(%d,%d)      :"%(n, i),
        print k_composition(n,i)
        print "weak composition(%d,%d) :"%(n, i),
        print weak_k_composition(n, i)


if __name__ == '__main__':

    factorial_demo()
    permutation_demo()
    combination_demo()
    catalan_demo()
    composition_demo()

