# -*- coding: utf-8 -*-
# vi:ts=4:et
# $Id: test_combination.py,v 1.2 2004/05/02 11:31:53 etale Exp $
# =====================================================

"""
unittest for combination.py
"""
import unittest
from test import test_support

from young import *


class TestPermutation(unittest.TestCase):
    def test_perm(self):
        n = 3
        r = range(n)

        expectations = [[2, 0, 1], [1, 0, 2], [0, 2, 1], [1, 2, 0], [0, 1, 2], [2, 1, 0]]
        for p in permutation(r):
            self.assert_(p in expectations)

    def test_num_of_perm(self):
        n = 8
        n = 5
        for i in range(1, n):
            self.assertEqual(len(permutation(range(i))), factorial(i))


class TestCombination(unittest.TestCase):
    def test_comb_of_number(self):
        n = 10
        t = (1, 10, 45, 120, 210, 252, 210, 120, 45, 10, 1)
        for i in range(n+1):
            self.assertEqual(combination(n,i), t[i])

    def test_comb_of_sequence(self):
        s = 'abcd'

        expectations = (
        [[]] ,
        [['a'], ['b'], ['c'], ['d']] ,
        [['a', 'b'], ['a', 'c'], ['a', 'd'], ['b', 'c'], ['b', 'd'], ['c', 'd']] ,
        [['a', 'b', 'c'], ['a', 'b', 'd'], ['a', 'c', 'd'], ['b', 'c', 'd']] ,
        [['a', 'b', 'c', 'd']] ,
        )

        for i in range(len(s)+1):
            self.assertEqual(combination(s, i), expectations[i])


class TestComposition(unittest.TestCase):
    def test_composition(self):
        # example is taken from Stanley, "EC vol.1", p.14.

        expectations = (1,3,3,1)
        n = 4
        for i in range(n):
            self.assertEqual(expectations[i], k_composition(n, i+1))

    def test_weak_composition(self):
        expectations = (1, 5, 15, 35)
        n = 4
        for i in range(n):
            self.assertEqual(expectations[i], weak_k_composition(n, i+1))


class TestFactorial(unittest.TestCase):
    def test_slice(self):
        n = 10
        t = (3628800, 3628800, 1814400, 604800, 151200, 30240, 5040, 720, 90, 10)
        for i in range(n):
            self.assertEqual(factorial(i+1, n), t[i])

        for i in range(1, n):
            self.assertEqual(factorial(i, i), i)

    def test_op(self):
        t = (1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880)
        for i in range(10):
            self.assertEqual(factorial(i), t[i])

class TestCatalan(unittest.TestCase):
    def test_equality(self):
        gen = catalan_generator()
        for i in range(10):
            self.assertEqual(catalan(i), gen.next())

def test_main(verbose=None):
    testclasses = (
            TestFactorial,
            TestCatalan,
            TestPermutation,
            TestCombination,
            TestComposition,
            )

    test_support.run_unittest(*testclasses)

if __name__ == '__main__':
    test_main()
