# -*- coding: utf-8 -*-
# vi:ts=4:et
#
# $Date: 2003/08/18 14:59:50 $
# $Revision: 1.3 $
# =====================================================

"""pretty print library for math"""

import sys
import pprint

try:
    from cStringIO import StringIO
except ImportError:
    from StringIO import StringIO

__all__     = [
               'pprint_whole_tableaux',
               'pprint_tableaux',
               'pprint_factorial',
               'pprint_partition',
               ]


def pprint_whole_tableaux(part, tableaux):
    '''pretty print all the tableaux
    '''
    buff = StringIO()
    buff.write('\n')
    buff.write(pprint_partition(part) + "\n")
    buff.write('='*40 + "\n")
    for table in tableaux:
        buff.write(pprint_tableaux(table))
        buff.write('-'*20 + "\n")

    return buff.getvalue()

def pprint_tableaux(tableaux):
    '''pretty print tableaux
    '''
    buff = StringIO()
    for cor in tableaux:
        '''# convert int -> str
        [1,2,3] -> ['1', '2', '3']
        '''
        cor = map(str, cor)
        buff.write(" ".join(cor) + "\n")
    #buff.write('\n')
    return buff.getvalue()

def pprint_partition(part, prefix = '(', suffix = ')'):
    '''pretty print partition
    '''
    # convert int -> str
    # ( 3,2,1,1) -> ('3', '2', '1', '1')
    part= map(str, part)
    return prefix + ",".join(part) + suffix

def pprint_factorial(number):
    '''pretty print factorial
    '''
    # 3 -> 3 x 2 x 1
    l = range(number, 0, -1)
    str_l = map(str, l)
    return "x".join(str_l)

