package org.hamano3.yubin;

import java.io.Serializable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * The <code>Code</code> class represents postal code.
 * $Id: Code.java,v 1.1.1.1 2004/09/24 06:52:40 tsukasa_asm Exp $
 * @author <a href="mailto:code@hamano3.org">Tsukasa HAMANO</a>
 * @since JDK1.3
 */

public abstract class Code implements Serializable {

    /** ログ。 */
    private static Log log = LogFactory.getLog(Code.class);

    /**
     * 郵便番号。
     */
    private int code;
    
    /**
     * コンストラクタ。
     */
    public Code() {
	setCode(0);
    }
    
    /**
     * コンストラクタ。
     * @param c 郵便番号
     */
    public Code(final int c) {
	setCode(c);
    }

    /**
     * 郵便番号を設定します.
     * @param c 郵便番号
     * @throws IllegalArgumentException 不正な郵便番号
     */
    public void setCode(final int c) {
	if (c < 0) {
	    throw new IllegalArgumentException();
	}
        code = c;
    }

    /**
     * 郵便番号を取得します
     * @return 郵便番号
     */
    public int getCode() {
        return code;
    }
    
    /**
     * オブジェクトの内容を文字列で返します
     * @return オブジェクトの内容
     */
    public abstract String toString();
}
