package org.hamano3.yubin;

import java.io.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * The <code>Code5</code> class represents 5 disit postal code.
 * $Id: Code5.java,v 1.1.1.1 2004/09/24 06:52:40 tsukasa_asm Exp $
 * @author <a href="mailto:code@hamano3.org">Tsukasa HAMANO</a>
 * @since JDK1.3
 */

public class Code5 extends Code {

    /** ログ. */
    public static Log log = LogFactory.getLog(Code5.class);

    /**
     * コンストラクタ.
     */
    public Code5() {
	super();
    }

    /**
     * コンストラクタ.
     * @param c 郵便番号(5桁)
     */
    public Code5(int c) {
	super(c);
    }

    /**
     * コンストラクタ.
     * @param c 郵便番号文字列.
     * @throws IllegalArgumentException 文字列が構文解析可能なCode5を含まない場合
     */
    public Code5(String c) throws IllegalArgumentException {
	Code5Format f = new Code5Format();
	setCode(f.parseCode(c));
    }

    /**
     * 郵便番号を設定します.
     * @param c 郵便番号
     * @throws IllegalArgumentException 不正な郵便番号
     */
    public void setCode(int c){
	if(c > 99999){
	    throw new IllegalArgumentException();
	}
	super.setCode(c);
    }

    /**
     * オブジェクトの内容を文字列で返します.
     * @return オブジェクトの内容
     */
    public String toString(){
	Code5Format f = new Code5Format();
	return f.format(this);
    }

}
