package org.hamano3.yubin;

import java.io.*;

import org.apache.commons.logging.*;

/**
 * The <code>Code7</code> class represents 7 disit postal code.
 * $Id: Code7.java,v 1.1.1.1 2004/09/24 06:52:40 tsukasa_asm Exp $
 * @author <a href="mailto:code@hamano3.org">Tsukasa HAMANO</a>
 * @since JDK1.3
 */

public class Code7 extends Code{

    /** ログ. */
    public static Log log = LogFactory.getLog(Code7.class);
    
    /**
     * コンストラクタ.
     */
    public Code7(){
	super();
    }

    /**
     * コンストラクタ
     * @param c 郵便番号(7桁)
     */
    public Code7(int c){
	super(c);
    }

    /**
     * コンストラクタ
     * @param c 郵便番号文字列
     * @throws Exception 文字列が構文解析可能なCode7を含まない場合
     */
    public Code7(String c) throws IllegalArgumentException{
	Code7Format f = new Code7Format();
	setCode(f.parseCode(c));
    }

    /**
     * 郵便番号を設定します
     * @param c 郵便番号
     * @throws IllegalArgumentException 不正な郵便番号
     */
    public void setCode(int c){
	if(c > 9999999){
	    throw new IllegalArgumentException();
	}
	super.setCode(c);
    }

    /**
     * オブジェクトの内容を文字列で返します
     * @return オブジェクトの内容
     */
    public String toString(){
	Code7Format f = new Code7Format();
	return f.format(this);
    }

}
