package org.hamano3.yubin;

import java.text.*;

import org.apache.commons.logging.*;

/**
 * The <code>Code7Format</code> is provides the interface for formatting and parsing 7 disit postal code.
 * $Id: Code7Format.java,v 1.1.1.1 2004/09/24 06:52:40 tsukasa_asm Exp $
 * @author <a href="mailto:code@hamano3.org">Tsukasa HAMANO</a>
 * @since JDK1.3
 */

public class Code7Format extends Format{
    /** ログ */
    public static Log log = LogFactory.getLog(Code7Format.class);


    /**
     * Code7オブジェクトをフォーマットし、指定された文字列バッファに結果のテキストを追加します。
     * @param obj フォーマットするCode7オブジェクト
     * @param toAppendTo テキストを追加する位置
     * @param pos フォーマットされたテキスト内のフィールドを識別する FieldPosition
     */
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos){
	if(toAppendTo == null || pos == null){
	    throw new NullPointerException();
	}

	if (!(obj instanceof Code7)){
	    throw new IllegalArgumentException("Cannot format given Object as a Code7");
	}

	int code = ((Code7)obj).getCode();

	if(code > 9999999){
	    throw new IllegalArgumentException("Object is over 7 disit");
	}

	int field = code / 10000;

	if(field  < 10){
	    toAppendTo.append("00");
	}else if(field  < 100){
	    toAppendTo.append("0");
	}

	toAppendTo.append(field);
	toAppendTo.append('-');

	field = code % 10000;

	if(field  < 10){
	    toAppendTo.append("000");
	}else if(field  < 100){
	    toAppendTo.append("00");
	}else if(field  < 1000){
	    toAppendTo.append("0");
	}
	toAppendTo.append(field);
	
	return toAppendTo;
    }

    /**
     * 文字列からテキストを解析してオブジェクトを生成します。
     * @param source 部分的に解析される String
     * @return 文字列から解析された郵便番号
     */
    public int parseCode(String source){
	int code;

	if(!valid(source)){
	    throw new IllegalArgumentException();
	}

	try{
	    
	    String token[] = source.split("-");
	    if(token.length == 1){
		code = Integer.parseInt(token[0]);
	    }else if(token.length == 2){
		code = Integer.parseInt(token[0]) * 10000;
		code += Integer.parseInt(token[1]);
	    }else{
		throw new IllegalArgumentException();
	    }


	}catch(Exception e){
	    throw new IllegalArgumentException();
	}
	return code;
    }

    /**
     * 文字列からテキストを解析してオブジェクトを生成します。
     * @param source 部分的に解析される String
     * @param pos 上記のインデックスおよびエラーインデックス情報を持つ ParsePosition オブジェクト
     * @return 文字列から解析された Object
     */
    public Object parseObject(String source,ParsePosition pos){
	Code7 code = null;
	try{
	    code = new Code7(parseCode(source));
	}catch(Exception e){
	    return null;
	}
	return code;
    }

    
    public static boolean valid(String source){
	if(source.matches("[0-9][0-9][0-9]-?[0-9][0-9][0-9][0-9]")){
	    return true;
	}

	return false;
    }

}
