package org.hamano3.yubin;

import java.util.*;
import java.io.*;
import java.sql.*;
import java.net.URL;

import org.apache.commons.logging.*;

/**
 * <code>DbManager</code> is database connection base class.
 * $Id: DbManager.java,v 1.1.1.1 2004/09/24 06:52:38 tsukasa_asm Exp $
 * @author <a href="mailto:code@hamano3.org">Tsukasa HAMANO</a>
 * @since JDK1.3
 */

public class DbManager{

    /** ログ */
    public static Log log = LogFactory.getLog(DbManager.class);

    /** データベースドライバー */
    public static String dbDriver;
    /** データベースURL */
    public static String dbUrl;
    /** データベース接続オプション */
    public static String dbOption;
    /** データベース接続ユーザID*/
    public static String dbUser;
    /** データベース接続ユーザパスワード*/
    public static String dbPassword;

    /** コネクションインターフェイス */
    public Connection conn = null;
    /** 問い合わせ結果格納インターフェイス */
    public ResultSet rs = null;
    /** 問い合わせ発行インターフェイス */
    public Statement stmt = null;
    /** プリコンパイル可能問い合わせ発行インターフェイス */
    public PreparedStatement pstmt = null;
    /** 問い合わせ結果メタデータ */
    public ResultSetMetaData rsmd = null;

    /**
     * コンストラクタ
     */
    public DbManager(){

	// データベースプロパティファイルの読み込み
        try{
	    Properties prop = new Properties();
	    prop.load(getClass().getResourceAsStream("/db.properties"));

	    dbDriver = prop.getProperty("db.driver");
	    dbUser = prop.getProperty("db.user");
	    dbOption = prop.getProperty("db.option");
	    dbPassword = prop.getProperty("db.password");
	    dbUrl = prop.getProperty("db.url");
        }catch(Exception e){
	    log.error("resourcefile db.property missing!");
	    log.error(e);
        }
    }

    /**
     * データベースへの接続を行います
     * @throws SQLException データーベースへの接続に失敗したときにスローします
     */
    public void open() throws SQLException{
        try {
            Class.forName(dbDriver).newInstance();

            this.conn = DriverManager.getConnection(dbUrl + dbOption, dbUser, dbPassword);
	    //poolman
	    //this.conn = DriverManager.getConnection(dbUrl);




        } catch (Exception e) {
	    log.error(e);
	    throw new SQLException();
        }
    }

    /**
     * データベースへの接続を閉じます
     */
    public void close() throws SQLException{

        if(this.rs != null) {

            try {
                this.rs.close();
            } catch (SQLException SQLE) {
		;
            }
        }

        if(this.stmt != null) {

            try {
                this.stmt.close();
            } catch (SQLException SQLE) {
		;
            }
        }

        if(this.pstmt != null) {

            try {
                this.pstmt.close();
            } catch (SQLException SQLE) {
                ;
            }
        }

        if(this.conn != null) {

            try {
                this.conn.close();
            } catch (SQLException SQLE) {
		;
            } catch (Exception E) {
		//テーブルLOCKを行ったときに起こりうる
		;
            }
        }
    }




}
