package org.hamano3.yubin;

import java.io.*;

import org.apache.commons.logging.*;


/**
 * <code>Import</code>is to insert yubin data to database.
 * $Id: Import.java,v 1.1.1.1 2004/09/24 06:52:40 tsukasa_asm Exp $
 * @author <a href="mailto:code@hamano3.org">Tsukasa HAMANO</a>
 * @since JDK1.3
 */

public class Import{
    String encoding = "Shift_JIS";
    public static Log log = LogFactory.getLog(Import.class); 

    public Import(){
	
    }

    public static void main(String args[]){
	String fn = null;

	if(args.length < 1){
	    log.error("Usage: Import file");
	    return;
	}
	
	fn = args[0];
	Import im = new Import();
	im.fileImport(new File(fn));
	

    }

    public void fileImport(File f){
	String line;
	int count = 0;
	Yubin yubin;
	YubinManager ym =  new YubinManager();

	
	try {

	    BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f), encoding));

	    while ((line = br.readLine()) != null) {
		//log.debug(line);
		yubin = line2Yubin(line);
		ym.insertYubin(yubin);
		
		count++;
		if(count % 1000 == 0){
		    log.debug("insert " + count + " records");
		}
		//break;
	    }

	} catch (Exception e) {
	    
	    log.error("import error", e);
	}
    }

    public Yubin line2Yubin(String l) throws Exception{
	String token[] = l.split("(\")?,(\")?");
	if(token.length != 15){
	    throw new Exception("error column="+token.length);
	}

	Yubin yubin= new Yubin(
			       new Code7(token[2]),
			       new Code5(token[1].replace(' ','0')),
			       Integer.parseInt(token[0]),
			       token[3],
			       token[4],
			       token[5],
			       token[6],
			       token[7],
			       token[8],
			       Byte.parseByte(token[9]),
			       Byte.parseByte(token[10]),
			       Byte.parseByte(token[11]),
			       Byte.parseByte(token[12]),
			       Byte.parseByte(token[13]),
			       Byte.parseByte(token[14])
			       );
	
	//log.debug(yubin.toString());

	return yubin;
    }
    
}
