package org.hamano3.yubin;

import java.io.*;

import org.apache.commons.logging.*;



/**
 * <code>Main</code> is main class.
 * $Id: Main.java,v 1.1.1.1 2004/09/24 06:52:38 tsukasa_asm Exp $
 * @author <a href="mailto:code@hamano3.org">Tsukasa HAMANO</a>
 * @since JDK1.3
 */

public class Main{

    public static Log log = LogFactory.getLog(Main.class); 

    public Main(){
	
    }

    public static void main(String args[]){
	String postalCode = null;

	if(args.length < 1){
	    log.error("Usage: [Postal Code]");
	    return;
	}
	
	postalCode = args[0];

	if(!postalCode.matches("[0-9][0-9][0-9]-?[0-9][0-9][0-9][0-9]")){
	    System.err.println("Error Postal Code");
	    return;
	}
	
	//log.info("Strat Debug");
	try {
	    YubinManager ym = new YubinManager();
	    Yubin yubin = ym.getYubinByCode7(new Code7(postalCode));
	    log.info(yubin);


	} catch (Exception e) {
	    e.printStackTrace();
	}

    }  
}
