package org.hamano3.yubin;

import java.io.*;

import org.apache.commons.logging.*;

/**
 * The <code>Yubin</code> class represents yubin data.
 * $Id: Yubin.java,v 1.1.1.1 2004/09/24 06:52:39 tsukasa_asm Exp $
 * @author <a href="mailto:code@hamano3.org">Tsukasa HAMANO</a>
 * @since JDK1.3
 */

public class Yubin implements Serializable{

    /** ログ */
    public static Log log = LogFactory.getLog(Yubin.class);

    /** 郵便番号(7桁) */
    private Code7 code7;
    /** (旧)郵便番号(5桁) */
    private Code5 code5;
    /** 全国地方公共団体コード */
    private int nationalCode;
    /** 都道府県名(カタカナ) */
    private String prefNameKana;
    /** 市区町村名(カタカナ) */
    private String cityNameKana;
    /** 町域名(カタカナ) */
    private String townNameKana;
    /** 都道府県名 */
    private String prefName;
    /** 市区町村名 */
    private String cityName;
    /** 町域名 */
    private String townName;
    /** 一町域が二以上の郵便番号で表される場合の表示 */
    private byte duplicationCode;
    /** 小字毎に番地が起番されている町域の表示 */
    private byte koazaEven;
    /** 丁目を有する町域の場合の表示 */
    private byte haveChome;
    /** 一つの郵便番号で二以上の町域を表す場合の表示 */
    private byte duplicationTown;
    /** 更新の表示 */
    private byte updateFlag;
    /** 変更理由 */
    private byte changeReason;

    /**
     * コンストラクタ
     */
    public Yubin(){
        setCode7(new Code7(0));
        setCode5(new Code5(0));
	setNationalCode(0);
        setPrefNameKana(null);
        setCityNameKana(null);
        setTownNameKana(null);
        setPrefName(null);
        setCityName(null);
        setTownName(null);
        setDuplicationCode((byte)0);
        setKoazaEven((byte)0);
        setHaveChome((byte)0);
        setDuplicationTown((byte)0);
        setUpdateFlag((byte)0);
        setChangeReason((byte)0);
    }

    /**
     * 指定したデータで初期化します
     
     * @param c7 郵便番号(7桁)
     * @param c5 (旧)郵便番号(5桁)
     * @param nc 全国地方公共団体コード
     * @param pnk 都道府県名(カタカナ)
     * @param cnk 市区町村名(カタカナ)
     * @param tnk 町域名(カタカナ)
     * @param pn 都道府県名
     * @param cn 市区町村名
     * @param tn 町域名
     * @param dc 一町域が二以上の郵便番号で表される場合の表示
     * @param ke 小字毎に番地が起番されている町域の表示
     * @param hc 丁目を有する町域の場合の表示
     * @param dt 一つの郵便番号で二以上の町域を表す場合の表示
     * @param uf 更新の表示
     * @param cr 変更理由
     */
    public Yubin(Code7 c7, Code5 c5, int nc, String pnk, String cnk, String tnk, String pn, String cn, String tn, byte dc, byte ke, byte hc, byte dt, byte uf, byte cr){
        setCode7(c7);
        setCode5(c5);
	setNationalCode(nc);
        setPrefNameKana(pnk);
        setCityNameKana(cnk);
        setTownNameKana(tnk);
        setPrefName(pn);
        setCityName(cn);
        setTownName(tn);
        setDuplicationCode(dc);
        setKoazaEven(ke);
        setHaveChome(hc);
        setDuplicationTown(dt);
        setUpdateFlag(uf);
        setChangeReason(cr);
    }

    /**
     * オブジェクトの内容を文字列で返します
     * @return オブジェクトの内容
     */
    public String toString(){

	return "\n" +
	    "Code7          = " + getCode7() + "\n" +
	    "Code5          = " + getCode5() + "\n" +
	    "NationalCode   = " + getNationalCode() + "\n" +
	    "PrefNameKana   = " + getPrefNameKana() + "\n" +
	    "CityNameKana   = " + getCityNameKana() + "\n" +
	    "TownNameKana   = " + getTownNameKana() + "\n" +
	    "PrefName       = " + getPrefName() + "\n" +
	    "CityName       = " + getCityName() + "\n" +
	    "TownName       = " + getTownName() + "\n" +
	    "DuplicationCode= " + getDuplicationCode() + "\n" +
	    "KoazaEven      = " + getKoazaEven() + "\n" +
	    "HaveChome      = " + getHaveChome() + "\n" +
	    "DuplicationTown= " + getDuplicationTown() + "\n" +
	    "UpdateFlag     = " + getUpdateFlag() + "\n" +
	    "ChangeReason   = " + getChangeReason() + "\n";
    }

    /**
     * 郵便番号(7桁)を設定します
     * @param c 郵便番号(7桁)
     */
    public void setCode7(Code7 c){
        code7 = c;
    }

    /**
     * 郵便番号(7桁)を取得します
     * @return 郵便番号(7桁)
     */
    public Code7 getCode7(){
        return code7;
    }

    /**
     * (旧)郵便番号(5桁)を設定します
     * @param c (旧)郵便番号(5桁)
     */
    public void setCode5(Code5 c){
        code5 = c;
    }

    /**
     * (旧)郵便番号(5桁)を取得します
     * @return (旧)郵便番号(5桁)
     */
    public Code5 getCode5(){
        return code5;
    }

    /**
     * 全国地方公共団体コードを設定します
     * @param n 全国地方公共団体コード
     */
    public void setNationalCode(int n){
        nationalCode = n;
    }

    /**
     * 全国地方公共団体コードを取得します
     * @return 全国地方公共団体コード
     */
    public int getNationalCode(){
        return nationalCode;
    }

    /**
     * 都道府県名(カタカナ)を設定します
     * @param p 都道府県名(カタカナ)
     */
    public void setPrefNameKana(String p){
        prefNameKana = p;
    }

    /**
     * 都道府県名(カタカナ)を取得します
     * @return 都道府県名(カタカナ)
     */
    public String getPrefNameKana(){
        return prefNameKana;
    }

    /**
     * 市区町村名(カタカナ)を設定します
     * @param c 市区町村名(カタカナ)
     */
    public void setCityNameKana(String c){
        cityNameKana = c;
    }

    /**
     * 市区町村名(カタカナ)を取得します
     * @return 市区町村名(カタカナ)
     */
    public String getCityNameKana(){
        return cityNameKana;
    }

    /**
     * 町域名(カタカナ)を設定します
     * @param t 町域名(カタカナ)
     */
    public void setTownNameKana(String t){
        townNameKana = t;
    }

    /**
     * 町域名(カタカナ)を取得します
     * @return 町域名(カタカナ)
     */
    public String getTownNameKana(){
        return townNameKana;
    }

    /**
     * 都道府県名を設定します
     * @param p 都道府県名
     */
    public void setPrefName(String p){
        prefName = p;
    }

    /**
     * 都道府県名を取得します
     * @return 都道府県名
     */
    public String getPrefName(){
        return prefName;
    }

    /**
     * 市区町村名を設定します
     * @param c 市区町村名
     */
    public void setCityName(String c){
        cityName = c;
    }

    /**
     * 市区町村名を取得します
     * @return 市区町村名
     */
    public String getCityName(){
        return cityName;
    }

    /**
     * 町域名を設定します
     * @param t 町域名
     */
    public void setTownName(String t){
        townName = t;
    }

    /**
     * 町域名を取得します
     * @return 町域名
     */
    public String getTownName(){
        return townName;
    }

    /**
     * 一町域が二以上の郵便番号で表される場合の表示を設定します
     * @param d 一町域が二以上の郵便番号で表される場合の表示(「1」は該当、「0」は該当せず)
     */
    public void setDuplicationCode(byte d){
        duplicationCode = d;
    }

    /**
     * 一町域が二以上の郵便番号で表される場合の表示を取得します
     * @return 一町域が二以上の郵便番号で表される場合の表示(「1」は該当、「0」は該当せず)
     */
    public byte getDuplicationCode(){
        return duplicationCode;
    }

    /**
     * 小字毎に番地が起番されている町域の表示を設定します
     * @param k 小字毎に番地が起番されている町域の表示(「1」は該当、「0」は該当せず)
     */
    public void setKoazaEven(byte k){
        koazaEven = k;
    }

    /**
     * 小字毎に番地が起番されている町域の表示を取得します
     * @return 小字毎に番地が起番されている町域の表示(「1」は該当、「0」は該当せず)
     */
    public byte getKoazaEven(){
        return koazaEven;
    }

    /**
     * 丁目を有する町域の場合の表示を設定します
     * @param h 丁目を有する町域の場合の表示(「1」は該当、「0」は該当せず)
     */
    public void setHaveChome(byte h){
        haveChome = h;
    }

    /**
     * 丁目を有する町域の場合の表示を取得します
     * @return 丁目を有する町域の場合の表示(「1」は該当、「0」は該当せず)
     */
    public byte getHaveChome(){
        return haveChome;
    }

    /**
     * 一つの郵便番号で二以上の町域を表す場合の表示を設定します
     * @param d 一つの郵便番号で二以上の町域を表す場合の表示(「1」は該当、「0」は該当せず)
     */
    public void setDuplicationTown(byte d){
        duplicationTown = d;
    }

    /**
     * 一つの郵便番号で二以上の町域を表す場合の表示を取得します
     * @return 一つの郵便番号で二以上の町域を表す場合の表示(「1」は該当、「0」は該当せず)
     */
    public byte getDuplicationTown(){
        return duplicationTown;
    }

    /**
     * 更新の表示を設定します
     * @param u 更新の表示(「1」は該当、「0」は該当せず)
     */
    public void setUpdateFlag(byte u){
        updateFlag = u;
    }

    /**
     * 更新の表示を取得します
     * @return 更新の表示(「1」は該当、「0」は該当せず)
     */
    public byte getUpdateFlag(){
        return updateFlag;
    }

    /**
     * 変更理由を設定します
     * @param c 変更理由(「0」は変更なし、「1」市政・区政・町政・分区・政令指定都市施行、「2」住居表示の実施、「3」区画整理、「4」郵便区調整、集配局新設、「5」訂正、「6」廃止(廃止データのみ使用))
     */
    public void setChangeReason(byte c){
        changeReason = c;
    }

    /**
     * 変更理由を取得します
     * @return 変更理由(「0」は変更なし、「1」市政・区政・町政・分区・政令指定都市施行、「2」住居表示の実施、「3」区画整理、「4」郵便区調整、集配局新設、「5」訂正、「6」廃止(廃止データのみ使用))
     */
    public byte getChangeReason(){
        return changeReason;
    }



}
