package org.hamano3.yubin;

import java.sql.*;

import org.apache.commons.logging.*;

/**
 * 住所データテーブルを操作するクラス.
 * <p>データーベースに接続し、住所データを取得、更新を行います.</p>
 * $Id: YubinManager.java,v 1.1.1.1 2004/09/24 06:52:39 tsukasa_asm Exp $
 * @see Yubin
 * @author  Tsukasa Hamano
 * @since   JDK1.3
 */

public class YubinManager extends DbManager{

    /** ログ */
    public static Log log = LogFactory.getLog(YubinManager.class);

    /** 操作するテーブル名 */
    static public String dbTable = "yubin";


    /**
     * コンストラクタ
     */
    public YubinManager(){

    }

    /**
     * データベースに住所データを追加します
     * @param y 挿入するYubinオブジェクト
     * @throws SQLException データーベース操作に失敗したときにスローします
     */
    public void insertYubin(Yubin y) throws SQLException{
	String query = null;

	try{
	    open();
	    query = "INSERT INTO " + dbTable +"(Code7, Code5, NationalCode, PrefNameKana, CityNameKana, TownNameKana, PrefName, CityName, TownName, DuplicationCode, KoazaEven, HaveChome, DuplicationTown, UpdateFlag, ChangeReason) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	    pstmt = conn.prepareStatement(query);
	    
	    pstmt.setInt(1, y.getCode7().getCode());
	    pstmt.setInt(2, y.getCode5().getCode());
	    pstmt.setInt(3, y.getNationalCode());
	    pstmt.setString(4, y.getPrefNameKana());
	    pstmt.setString(5, y.getCityNameKana());
	    pstmt.setString(6, y.getTownNameKana());
	    pstmt.setString(7, y.getPrefName());
	    pstmt.setString(8, y.getCityName());
	    pstmt.setString(9, y.getTownName());
	    pstmt.setByte(10, y.getDuplicationCode());
	    pstmt.setByte(11, y.getKoazaEven());
	    pstmt.setByte(12, y.getHaveChome());
	    pstmt.setByte(13, y.getDuplicationTown());
	    pstmt.setByte(14, y.getUpdateFlag());
	    pstmt.setByte(15, y.getChangeReason());

	    int result = pstmt.executeUpdate();
	    pstmt.getUpdateCount();
	    pstmt.clearParameters();
	} catch (Exception e) {
	    log.error(e);
	    throw new SQLException();
	} finally {
	    close();
	}
    }

    /**
     * 7桁郵便番号から住所データを取得します
     * @param code
     * @return 住所データを返します、ユーザが存在しなかった場合nullを返します
     * @throws SQLException データーベース操作に失敗したときにスローします
     */
    public Yubin getYubinByCode7(Code7 code) throws SQLException{
	Yubin yubin;
	String query = null;
	
	try{
	    open();
	    query = "SELECT Code7, Code5, NationalCode, PrefNameKana, CityNameKana, TownNameKana, PrefName, CityName, TownName, DuplicationCode, KoazaEven, HaveChome, DuplicationTown, UpdateFlag, ChangeReason FROM " + dbTable + " WHERE Code7=?;";

	    pstmt = conn.prepareStatement(query);
	    pstmt.setInt(1, code.getCode());
	    rs = pstmt.executeQuery();
	    rsmd = rs.getMetaData();

	    if(!rs.next()){
		return null;
	    }

	    yubin= new Yubin(
			     new Code7(rs.getInt(1)),
			     new Code5(rs.getInt(2)),
			     rs.getInt(3),
			     rs.getString(4),
			     rs.getString(5),
			     rs.getString(6),
			     rs.getString(7),
			     rs.getString(8),
			     rs.getString(9),
			     rs.getByte(10),
			     rs.getByte(11),
			     rs.getByte(12),
			     rs.getByte(13),
			     rs.getByte(14),
			     rs.getByte(15)
			     );


	    pstmt.clearParameters();
	   
	} catch (Exception e) {
	    throw new SQLException();
	} finally {
	    close();
	}

	return yubin;
    }

    /**
     * 7桁郵便番号から住所データを削除します
     * @param y 挿入するYubinオブジェクト
     * @throws SQLException データーベース操作に失敗したときにスローします
     */
    public void deleteYubinByCode7(Code7 code) throws SQLException{
	String query = null;

	try{
	    open();
	    query = "DELETE FROM " + dbTable +" WHERE Code7=?;";

	    pstmt = conn.prepareStatement(query);
	    pstmt.setInt(1, code.getCode());

	    int result = pstmt.executeUpdate();
	    pstmt.getUpdateCount();
	    pstmt.clearParameters();
	} catch (Exception e) {
	    log.error(e);
	    throw new SQLException();
	} finally {
	    close();
	}
    }

}
