package org.hamano3.yubin;

import junit.framework.TestCase;

public class Code5Test extends TestCase {

    public void testConstructor1() {
	try { 
	    new Code5();
	    new Code5(0);
	    new Code5(1);
	    new Code5(99999);
	} catch (Exception e) {
	    fail();
	}
    }

    public void testConstructorError1() {
	try { 
	    new Code5(-1);
	    fail();
	} catch (Exception e) {
	}

	try { 
	    new Code5(100000);
	    fail();
	} catch (Exception e) {
	}
    }

    public void testConstructor2() {
	try { 
	    new Code5("00000");
	    new Code5("000-00");
	    new Code5("11111");
	    new Code5("111-11");
	    new Code5("99999");
	    new Code5("999-99");
	} catch (Exception e) {
	    fail();
	}
    }

    public void testConstructorError2() {
	try {
	    new Code5(null);
	    fail();
	} catch (Exception e) {
	}
	try {
	    new Code5("");
	    fail();
	} catch (Exception e) {
	}
	try {
	    new Code5("abcde");
	    fail();
	} catch (Exception e) {
	}
	try {
	    new Code5("-----");
	    fail();
	} catch (Exception e) {
	}
    }

    public void testCode() {
	try {
	    assertEquals(0, new Code5("00000").getCode());
	    assertEquals(0, new Code5("000-00").getCode());
	    assertEquals(11111, new Code5("11111").getCode());
	    assertEquals(11111, new Code5("111-11").getCode());
	    assertEquals(99999, new Code5("99999").getCode());
	    assertEquals(99999, new Code5("999-99").getCode());
	} catch (Exception e) {
	    fail();
	}
    }

    public void testToString() {
	try {
	    assertEquals("000-00", new Code5("00000").toString());
	    assertEquals("000-00", new Code5("000-00").toString());
	    assertEquals("111-11", new Code5("11111").toString());
	    assertEquals("111-11", new Code5("111-11").toString());
	    assertEquals("999-99", new Code5("99999").toString());
	    assertEquals("999-99", new Code5("999-99").toString());
	} catch (Exception e) {
	    fail();
	}
    }

}
