package org.hamano3.yubin;

import junit.framework.TestCase;

public class Code7Test extends TestCase {

    public void testConstructor1() {
	try { 
	    new Code7();
	    new Code7(0);
	    new Code7(1);
	    new Code7(9999999);
	} catch (Exception e) {
	    fail();
	}
    }

    public void testConstructorError1() {
	try { 
	    new Code7(-1);
	    fail();
	} catch (Exception e) {
	}

	try { 
	    new Code7(10000000);
	    fail();
	} catch (Exception e) {
	}
    }

    public void testConstructor2() {
	try { 
	    new Code7("0000000");
	    new Code7("000-0000");
	    new Code7("1111111");
	    new Code7("111-1111");
	    new Code7("9999999");
	    new Code7("999-9999");
	} catch (Exception e) {
	    fail();
	}
    }

    public void testConstructorError2() {
	try {
	    new Code7(null);
	    fail();
	} catch (Exception e) {
	}
	try {
	    new Code7("");
	    fail();
	} catch (Exception e) {
	}
	try {
	    new Code7("abcdefg");
	    fail();
	} catch (Exception e) {
	}
	try {
	    new Code7("-------");
	    fail();
	} catch (Exception e) {
	}
    }

    public void testCode() {
	try {
	    assertEquals(0, new Code7("0000000").getCode());
	    assertEquals(0, new Code7("000-0000").getCode());
	    assertEquals(1111111, new Code7("1111111").getCode());
	    assertEquals(1111111, new Code7("111-1111").getCode());
	    assertEquals(9999999, new Code7("9999999").getCode());
	    assertEquals(9999999, new Code7("999-9999").getCode());
	} catch (Exception e) {
	    fail();
	}
    }

    public void testToString() {
	try {
	    assertEquals("000-0000", new Code7("0000000").toString());
	    assertEquals("000-0000", new Code7("000-0000").toString());
	    assertEquals("111-1111", new Code7("1111111").toString());
	    assertEquals("111-1111", new Code7("111-1111").toString());
	    assertEquals("999-9999", new Code7("9999999").toString());
	    assertEquals("999-9999", new Code7("999-9999").toString());
	} catch (Exception e) {
	    fail();
	}
    }

}
