package org.hamano3.yubin;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class YubinManagerTest extends TestCase {

    YubinManager m = new YubinManager();

    public YubinManagerTest(String name) {
	super(name);
    }

    public static Test suite() {
	TestSuite suite= new TestSuite(YubinManagerTest.class.getName());
	suite.addTest(new YubinManagerTest("testInsertYubin"));
	suite.addTest(new YubinManagerTest("testGetYubinByCode7"));
	suite.addTest(new YubinManagerTest("testDeleteYubinByCode7"));

	return suite;
    }

    protected void setUp(){
	try {
	    //m = new YubinManager();
	} catch (Exception e) {
	    fail(e.toString());
	}
    }
    
    protected void tearDown(){
	try {
	} catch (Exception e) {
	    fail(e.toString());
	}
    }


    public void testInsertYubin() {
	try {
	    
	    Yubin yubin = new Yubin(
				   new Code7(0),
				   new Code5(1),
				   2,
				   "ｷﾞﾝｶﾞｹｲ",
				   "ﾀｲﾖｳｹｲ",
				   "ﾁｷｭｳ",
				   "銀河系",
				   "太陽系",
				   "地球",
				   (byte)0,(byte)0,(byte)0,(byte)0,(byte)0,(byte)0);
	    m.insertYubin(yubin);
	} catch (Exception e) {
	    fail(e.toString());
	}
    }

    public void testGetYubinByCode7() {
	try {
	    Yubin yubin = m.getYubinByCode7(new Code7(0));
	    assertTrue(yubin.getCode7().getCode() == 0);
	    assertTrue(yubin.getCode5().getCode() == 1);
	    assertTrue(yubin.getNationalCode() == 2);
	    assertEquals(yubin.getPrefName(), "銀河系");
	    assertEquals(yubin.getCityName(), "太陽系");
	    assertEquals(yubin.getTownName(), "地球");
	} catch (Exception e) {
	    fail(e.toString());
	}
    }

    public void testDeleteYubinByCode7() {
	try {
	    m.deleteYubinByCode7(new Code7(0));
	    Yubin yubin = m.getYubinByCode7(new Code7(0));
	    assertTrue(yubin == null);

	} catch (Exception e) {
	    fail(e.toString());
	}
    }
}
