<?php
/**
 * @package languageDefines
 * @copyright Copyright 2003-2006 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: english.php 3260 2006-03-26 00:18:01Z drbyte $
 */

// FOLLOWING WERE moved to meta_tags.php
//define('TITLE', 'Zen Cart!');
//define('SITE_TAGLINE', 'The Art of E-commerce');
//define('CUSTOM_KEYWORDS', 'ecommerce, open source, shop, online shopping');
// END: moved to meta_tags.php

  define('FOOTER_TEXT_BODY', 'Copyright &copy; 2003-2006 <a href="http://www.zen-cart.com" target="_blank">Zen Cart</a> Powered by <a href="http://www.zen-cart.com" target="_blank">zen-cart.com</a> / <a href="http://www.zen-cart.jp" target="_blank">zen-cart.jp</a>');

// look in your $PATH_LOCALE/locale directory for available locales..
// on RedHat try 'en_US'
// on FreeBSD try 'en_US.ISO_8859-1'
// on Windows try 'en', or 'English'
  @setlocale(LC_TIME, 'ja_JP.EUC-JP');
mb_language('Japanese');
mb_internal_encoding("EUC-JP");
mb_http_output("EUC-JP");

// if mbstring is not load, use mb-emulator 

  define('DATE_FORMAT_SHORT', '%Y/%m/%d');  // this is used for strftime()
  define('DATE_FORMAT_LONG', '%Yǯ%m%d(%a)'); // this is used for strftime()
  define('DATE_FORMAT', 'Y/m/d'); // this is used for date()
  define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');

// EMAIL config
  define('EMAIL_CHARSET', 'ISO-2022-JP');
  define('EMAIL_ENCODING', '7bit');
  define('EMAIL_MIMEHEADER', 'B');
  define('EMAIL_IS_MULTIBYTE', TRUE);

////
// Return date in raw format mm/dd/yyyy
// $date should be in format yyyy/mm/dd -- Change for Japanese date format
// raw date is in format YYYYMMDD, or DDMMYYYY
  if (!function_exists('zen_date_raw')) {
    function zen_date_raw($date, $reverse = false) {
      if ($reverse) {
    return substr($date, 8, 2) . substr($date, 5, 2) . substr($date, 0, 4);
      } else {
    return substr($date, 0, 4) . substr($date, 5, 2) . substr($date, 8, 2);
      }
    }
  }

// if USE_DEFAULT_LANGUAGE_CURRENCY is true, use the following currency, instead of the applications default currency (used when changing language)
  define('LANGUAGE_CURRENCY', 'JPY');

// Global entries for the <html> tag
  define('HTML_PARAMS','dir="ltr" lang="ja"');

// charset for web pages and emails
  define('CHARSET', 'EUC-JP');

// footer text in includes/footer.php
  define('FOOTER_TEXT_REQUESTS_SINCE', 'requests since');

// Define the name of your Gift Certificate as Gift Voucher, Gift Certificate, Zen Cart Dollars, etc. here for use through out the shop
  define('TEXT_GV_NAME','եȷ');
  define('TEXT_GV_NAMES','եȷ');

// used for redeem code, redemption code, or redemption id
  define('TEXT_GV_REDEEM','');

// text for gender
  define('MALE', '');
  define('FEMALE', '');
  define('MALE_ADDRESS', '');
  define('FEMALE_ADDRESS', '');

// text for date of birth example
  define('DOB_FORMAT_STRING', 'yyyy/mm/dd');

//text for sidebox heading links
  define('BOX_HEADING_LINKS', '&nbsp;&nbsp;[more]');

// categories box text in sideboxes/categories.php
  define('BOX_HEADING_CATEGORIES', 'ƥ');

// manufacturers box text in sideboxes/manufacturers.php
  define('BOX_HEADING_MANUFACTURERS', '᡼');

// whats_new box text in sideboxes/whats_new.php
  define('BOX_HEADING_WHATS_NEW', '徦');
  define('CATEGORIES_BOX_HEADING_WHATS_NEW', '徦...');

  define('BOX_HEADING_FEATURED_PRODUCTS', '');
  define('CATEGORIES_BOX_HEADING_FEATURED_PRODUCTS', 'ᾦ...');
  define('TEXT_NO_FEATURED_PRODUCTS', 'ᾦʤϤޤʤϿޤΤǡޤۤɤ');

  define('TEXT_NO_ALL_PRODUCTS', 'ʤϤޤʤϿޤΤǡޤۤɤ');
  define('CATEGORIES_BOX_HEADING_PRODUCTS_ALL', '...');

// quick_find box text in sideboxes/quick_find.php
  define('BOX_HEADING_SEARCH', 'ʸ');
  define('BOX_SEARCH_ADVANCED_SEARCH', 'ܺٸ');

// specials box text in sideboxes/specials.php
  define('BOX_HEADING_SPECIALS', 'ò');
  define('CATEGORIES_BOX_HEADING_SPECIALS','ò ...');

// reviews box text in sideboxes/reviews.php
  define('BOX_HEADING_REVIEWS', 'ӥ塼');
  define('BOX_REVIEWS_WRITE_REVIEW', 'ξʤΥӥ塼');
  define('BOX_REVIEWS_NO_REVIEWS', 'ʤΥӥ塼Ϥޤޤ');
  define('BOX_REVIEWS_TEXT_OF_5_STARS', '%s / 5');

// shopping_cart box text in sideboxes/shopping_cart.php
  define('BOX_HEADING_SHOPPING_CART', 'åԥ󥰥');
  define('BOX_SHOPPING_CART_EMPTY', 'Ȥ϶Ǥ');
  define('BOX_SHOPPING_CART_DIVIDER', '&nbsp;x&nbsp;');

// order_history box text in sideboxes/order_history.php
  define('BOX_HEADING_CUSTOMER_ORDERS', 'ǶΤʸ');

// best_sellers box text in sideboxes/best_sellers.php
  define('BOX_HEADING_BESTSELLERS', '٥ȥ顼');
  define('BOX_HEADING_BESTSELLERS_IN', '٥ȥ顼<br />&nbsp;&nbsp;');

// notifications box text in sideboxes/products_notifications.php
  define('BOX_HEADING_NOTIFICATIONS', 'Τ餻᡼');
  define('BOX_NOTIFICATIONS_NOTIFY', '<strong>%s</strong>ˤĤƤΤΤ餻᡼');
  define('BOX_NOTIFICATIONS_NOTIFY_REMOVE', '<strong>%s</strong>ˤĤƤΤΤ餻᡼ʤ');

// manufacturer box text
  define('BOX_HEADING_MANUFACTURER_INFO', 'ʾ');
  define('BOX_MANUFACTURER_INFO_HOMEPAGE', '%s Web');
  define('BOX_MANUFACTURER_INFO_OTHER_PRODUCTS', '¾ξ');

// languages box text in sideboxes/languages.php
  define('BOX_HEADING_LANGUAGES', '');

// currencies box text in sideboxes/currencies.php
  define('BOX_HEADING_CURRENCIES', '̲');

// information box text in sideboxes/information.php
  define('BOX_HEADING_INFORMATION', 'ե᡼');
  define('BOX_INFORMATION_PRIVACY', 'Ŀ;ݸ');
  define('BOX_INFORMATION_CONDITIONS', 'ѵ');
  define('BOX_INFORMATION_SHIPPING', 'ʤˤĤ');
  define('BOX_INFORMATION_CONTACT', '䤤碌');
  define('BOX_BBINDEX', 'ե');
  define('BOX_INFORMATION_UNSUBSCRIBE', '˥塼쥿Ͽ');

  define('BOX_INFORMATION_SITE_MAP', 'ȥޥå');

// information box text in sideboxes/more_information.php - were TUTORIAL_
  define('BOX_HEADING_MORE_INFORMATION', 'ɲþ');
  define('BOX_INFORMATION_PAGE_2', 'ڡ2');
  define('BOX_INFORMATION_PAGE_3', 'ڡ3');
  define('BOX_INFORMATION_PAGE_4', 'ڡ4');

// tell a friend box text in sideboxes/tell_a_friend.php
  define('BOX_HEADING_TELL_A_FRIEND', 'ͧãΤ餻');
  define('BOX_TELL_A_FRIEND_TEXT', 'ξʤͧãΤ餻');

// wishlist box text in includes/boxes/wishlist.php
  define('BOX_HEADING_CUSTOMER_WISHLIST', 'åꥹ');
  define('BOX_WISHLIST_EMPTY', 'åꥹȤ˲ϿƤޤ');
  define('IMAGE_BUTTON_ADD_WISHLIST', 'åꥹȤ˲ä');
  define('TEXT_WISHLIST_COUNT', 'ߥåꥹȤ˾ʤ %s ϿƤޤ');
  define('TEXT_DISPLAY_NUMBER_OF_WISHLIST', '<strong>%d</strong> <strong>%d</strong>ޤǤɽƤޤ (åꥹȤο:<strong>%d</strong>)');

//New billing address text
  define('SET_AS_PRIMARY' , 'ɸȤ');
  define('NEW_ADDRESS_TITLE', '轻');

// javascript messages
  define('JS_ERROR', 'եν˥顼ȯޤ\n\nιܤƤ:\n\n');

  define('JS_REVIEW_TEXT', '* ӥ塼ʸϤûޤ' . REVIEW_TEXT_MIN_LENGTH . 'ʸʾϤƤ');
  define('JS_REVIEW_RATING', '* ʤɾ򤷤Ƥ');

  define('JS_ERROR_NO_PAYMENT_MODULE_SELECTED', '* ʧˡ򤷤Ƥ');

  define('JS_ERROR_SUBMITTED', 'ϥեϴƤޤOK ܥ򥯥åƽλޤǤԤ');

  define('ERROR_NO_PAYMENT_MODULE_SELECTED', 'ʧˡ򤷤Ƥ');
  define('ERROR_CONDITIONS_NOT_ACCEPTED', 'ѵƱդϥåܥå򥯥åƤ');
  define('ERROR_PRIVACY_STATEMENT_NOT_ACCEPTED', 'Ŀ;ݸˤƱդϥåܥå򥯥åƤ');

  define('CATEGORY_COMPANY', '̾ʲҤǤѤξ');
  define('CATEGORY_PERSONAL', 'Ŀ;');
  define('CATEGORY_ADDRESS', '');
  define('CATEGORY_CONTACT', 'Ϣ');
  define('CATEGORY_OPTIONS', 'ץ');
  define('CATEGORY_PASSWORD', 'ѥ');
  define('CATEGORY_LOGIN', '');
  define('PULL_DOWN_DEFAULT', '̾򤷤Ƥ');

  define('ENTRY_COMPANY', '̾:');
  define('ENTRY_COMPANY_ERROR', '');
  define('ENTRY_COMPANY_TEXT', '');
  define('ENTRY_GENDER', ':');
  define('ENTRY_GENDER_ERROR', '̤򤷤Ƥ');
  define('ENTRY_GENDER_TEXT', '*');
  define('ENTRY_FIRST_NAME', ':');
  define('ENTRY_FIRST_NAME_ERROR', 'Ϻ' . ENTRY_FIRST_NAME_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_FIRST_NAME_TEXT', '*');
  define('ENTRY_LAST_NAME', '̾:');
  define('ENTRY_LAST_NAME_ERROR', '̾Ϻ' . ENTRY_LAST_NAME_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_LAST_NAME_TEXT', '*');
  // ->furikana
  define('ENTRY_FIRST_NAME_KANA', 'դ꤬:');
  define('ENTRY_FIRST_NAME_KANA_ERROR', 'դ꤬ʤϺ' . ENTRY_FIRST_NAME_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_FIRST_NAME_KANA_TEXT', '*');
  define('ENTRY_LAST_NAME_KANA', '̾դ꤬:');
  define('ENTRY_LAST_NAME_KANA_ERROR', '̾դ꤬ʤϺ' . ENTRY_LAST_NAME_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_LAST_NAME_KANA_TEXT', '*');
  // <-furikana
  define('ENTRY_DATE_OF_BIRTH', ':');
  define('ENTRY_DATE_OF_BIRTH_ERROR', '[1970/05/21](//)ν񼰤ϤƤ');
  define('ENTRY_DATE_OF_BIRTH_TEXT', '* ( 1970/05/21)');
  define('ENTRY_EMAIL_ADDRESS', 'E᡼륢ɥ쥹:');
  define('ENTRY_EMAIL_ADDRESS_ERROR', 'E᡼륢ɥ쥹ȾѤ' . ENTRY_EMAIL_ADDRESS_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_EMAIL_ADDRESS_CHECK_ERROR', '᡼륢ɥ쥹ϤƤʤ褦Ǥ');
  define('ENTRY_EMAIL_ADDRESS_ERROR_EXISTS', 'Υ᡼륢ɥ쥹ϤǤϿƤޤΥ᡼륢ɥ쥹ǥ󤵤뤫㤦ɥ쥹ǥȤϿƤ');
  define('ENTRY_EMAIL_ADDRESS_TEXT', '*');
  define('ENTRY_NICK', 'ե˥å͡:');
  define('ENTRY_NICK_TEXT', ''); // note to display beside nickname input field
  define('ENTRY_NICK_DUPLICATE_ERROR', 'Υ˥å͡ϤǤ˻ȤƤޤ');
  define('ENTRY_NICK_LENGTH_ERROR', '˥å͡Ϻ' . ENTRY_NICK_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_STREET_ADDRESS', ' ޥ󥷥󡦥ѡ̾:');
  define('ENTRY_STREET_ADDRESS_ERROR', ' ޥ󥷥󡦥ѡ̾Ϻ' . ENTRY_STREET_ADDRESS_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_STREET_ADDRESS_TEXT', '*');
  define('ENTRY_SUBURB', '2:');
  define('ENTRY_SUBURB_ERROR', '');
  define('ENTRY_SUBURB_TEXT', '');
  define('ENTRY_POST_CODE', '͹ֹ:');
  define('ENTRY_POST_CODE_ERROR', '͹ֹϺ' . ENTRY_POSTCODE_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_POST_CODE_TEXT', '*');
  define('ENTRY_CITY', 'Į¼:');
  define('ENTRY_CUSTOMERS_REFERRAL', 'Ȳ񥳡:');

  define('ENTRY_CITY_ERROR', 'Į¼̾Ϻ' . ENTRY_CITY_MIN_LENGTH . ' ʸʾϤƤ');
  define('ENTRY_CITY_TEXT', '*');
  define('ENTRY_STATE', 'ƻܸ:');
  define('ENTRY_STATE_ERROR', 'ƻܸ̾Ϻ' . ENTRY_STATE_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_STATE_ERROR_SELECT', 'ץ˥塼ƻܸ򤷤Ƥ');
  define('ENTRY_STATE_TEXT', '*');
  define('ENTRY_COUNTRY', '̾:');
  define('ENTRY_COUNTRY_ERROR', 'ץ˥塼̾򤷤Ƥ');
  define('ENTRY_COUNTRY_TEXT', '*');
  define('ENTRY_TELEPHONE_NUMBER', 'ֹ:');
  define('ENTRY_TELEPHONE_NUMBER_ERROR', 'ֹϺ' . ENTRY_TELEPHONE_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_TELEPHONE_NUMBER_TEXT', '*');
  define('ENTRY_FAX_NUMBER', 'եåֹ:');
  define('ENTRY_FAX_NUMBER_ERROR', '');
  define('ENTRY_FAX_NUMBER_TEXT', '');
  define('ENTRY_NEWSLETTER', '˥塼쥿ɤ');
  define('ENTRY_NEWSLETTER_TEXT', '');
  define('ENTRY_NEWSLETTER_YES', '');
  define('ENTRY_NEWSLETTER_NO', 'ɲ');
  define('ENTRY_NEWSLETTER_ERROR', '');
  define('ENTRY_PASSWORD', 'ѥ:');
  define('ENTRY_PASSWORD_ERROR', 'ѥɤϺ' . ENTRY_PASSWORD_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_PASSWORD_ERROR_NOT_MATCHING', 'ѥɤγǧƱѥɤϤƤ');
  define('ENTRY_PASSWORD_TEXT', '* (ȾѱѿǺ' . ENTRY_PASSWORD_MIN_LENGTH . 'ʸʾ)');
  define('ENTRY_PASSWORD_CONFIRMATION', 'ѥɤγǧ:');
  define('ENTRY_PASSWORD_CONFIRMATION_TEXT', '*');
  define('ENTRY_PASSWORD_CURRENT', 'ߤΥѥ:');
  define('ENTRY_PASSWORD_CURRENT_TEXT', '*');
  define('ENTRY_PASSWORD_CURRENT_ERROR', 'ѥɤȾѱѿǺ' . ENTRY_PASSWORD_MIN_LENGTH . ' ʸʾϤƤ');
  define('ENTRY_PASSWORD_NEW', 'ѥ:');
  define('ENTRY_PASSWORD_NEW_TEXT', '*');
  define('ENTRY_PASSWORD_NEW_ERROR', 'ѥɤȾѱѿ' . ENTRY_PASSWORD_MIN_LENGTH . 'ʸʾϤƤ');
  define('ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING', 'ѥɤγǧϿѥɤϤƤ');
  define('PASSWORD_HIDDEN', '--ɽޤ--');

  define('FORM_REQUIRED_INFORMATION', '* ɬܹ');
  define('ENTRY_REQUIRED_SYMBOL', '*');

  // constants for use in zen_prev_next_display function
  define('TEXT_RESULT_PAGE', '');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS', '<strong>%d</strong><strong>%d</strong> ɽ (ʤο: <strong>%d</strong>)');
define('TEXT_DISPLAY_NUMBER_OF_ORDERS', '<strong>%d</strong><strong>%d</strong> ɽ (ʸ: <strong>%d</strong>)');
define('TEXT_DISPLAY_NUMBER_OF_REVIEWS', '<strong>%d</strong><strong>%d</strong> ɽ (ӥ塼: <strong>%d</strong>)');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW', '<strong>%d</strong><strong>%d</strong> ɽ (徦ʤο: <strong>%d</strong>)');
define('TEXT_DISPLAY_NUMBER_OF_SPECIALS', '<strong>%d</strong><strong>%d</strong> ɽ (òʤο: <strong>%d</strong>)');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_FEATURED_PRODUCTS', '<strong>%d</strong><strong>%d</strong>ɽ (ᾦʤο:<strong>%d</strong>)');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_ALL', '<strong>%d</strong><strong>%d</strong>ɽ (ʤο:<strong>%d</strong>)');

define('PREVNEXT_TITLE_FIRST_PAGE', 'ǽΥڡ');
define('PREVNEXT_TITLE_PREVIOUS_PAGE', 'Υڡ');
define('PREVNEXT_TITLE_NEXT_PAGE', 'Υڡ');
define('PREVNEXT_TITLE_LAST_PAGE', 'ǸΥڡ');
define('PREVNEXT_TITLE_PAGE_NO', '%dڡ');
define('PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE', '%dڡ');
define('PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE', '%dڡ');
define('PREVNEXT_BUTTON_FIRST', '&lt;&lt;ǽ');
define('PREVNEXT_BUTTON_PREV', '[&lt;&lt;&nbsp;]');
define('PREVNEXT_BUTTON_NEXT', '[&nbsp;&gt;&gt;]');
define('PREVNEXT_BUTTON_LAST', 'Ǹ&gt;&gt;');

define('TEXT_BASE_PRICE','١: ');

define('TEXT_CLICK_TO_ENLARGE', 'ɽ');

  define('TEXT_SORT_PRODUCTS', 'ʤ¤ؤ ');
  define('TEXT_DESCENDINGLY', '߽');
  define('TEXT_ASCENDINGLY', '');
  define('TEXT_BY', ' by ');

define('TEXT_REVIEW_BY', ': %s');
define('TEXT_REVIEW_WORD_COUNT', '%s');
define('TEXT_REVIEW_RATING', 'ɾ: %s [%s]');
define('TEXT_REVIEW_DATE_ADDED', 'Ͽ: %s');
define('TEXT_NO_REVIEWS', 'ʤΥӥ塼Ϥޤޤ');

  define('TEXT_NO_NEW_PRODUCTS', '徦ʤϤޤʤϿޤΤǡޤۤɤ');

  define('TEXT_UNKNOWN_TAX_RATE', 'Ψ');

  define('TEXT_REQUIRED', '<span class="errorText">ɬ</span>');

  define('TEXT_TIME_SPECIFY','Ϥ');

  define('WARNING_REGISTER_GLOBALS_ON', 'ΥСregister_globalsOnǱѤƤޤ<br/>register_globalsϥƥǽ뤿ᡢZen Cartϡregister_globalsOffˤʤưޤ<br/>Zen CartΥ󥹥ȡǥ쥯ȥ.htaccessե뤬åץɤƤΤˤΥåɽƤ硢ΥСǤ.htaccessregister_globalsѹǤʤȤ̣Ƥޤ<br/>褹뤿ˤϡΤ2ĤΤɤ餫бɬפǤ<br/><br/><br/>1. Сѹ<br/>2. register_globalsOffǱѲǽʥС˺ƥ󥹥ȡ뤹');
  $warn_path = (isset($_SERVER['SCRIPT_FILENAME']) ? @dirname($_SERVER['SCRIPT_FILENAME']) : '.....');
  define('WARNING_INSTALL_DIRECTORY_EXISTS', 'ٹ: 󥹥ȡǥ쥯ȥ꤬Τޤ޻ĤäƤޤ : ' . $warn_path . '/zc_install. ƥʤΤǤΥǥ쥯ȥƤ');
  define('WARNING_CONFIG_FILE_WRITEABLE', 'ٹ: ե뤬񤭹߲ǽˤʤäƤޤ : ' . $warn_path . '/includes/configure.php. ƥʤΤǡΥե桼¤ꤷƲ');
  unset($warn_path);
  define('WARNING_SESSION_DIRECTORY_NON_EXISTENT', 'ٹ: å¸ǥ쥯ȥ꤬¸ߤޤ : ' . zen_session_save_path() . '. Υǥ쥯ȥ꤬ޤǥåǽưޤ');
  define('WARNING_SESSION_DIRECTORY_NOT_WRITEABLE', 'ٹ: å¸ǥ쥯ȥ˽񤭹ߤǤޤ: ' . zen_session_save_path() . '. ꤵޤǥåǽưޤ');
  define('WARNING_SESSION_AUTO_START', 'ٹ: session.auto_start ͭˤʤäƤޤ - phpǽphp.ini̵ˤWebФƵưƤ');
  define('WARNING_DOWNLOAD_DIRECTORY_NON_EXISTENT', 'ٹ: ɾʥǥ쥯ȥ꤬¸ߤޤ: ' . DIR_FS_DOWNLOAD . '. Υǥ쥯ȥ꤬ͭˤʤޤǥɾʵǽưޤ');
  define('WARNING_SQL_CACHE_DIRECTORY_NON_EXISTENT', 'ٹ: SQLåǥ쥯ȥ꤬¸ߤޤ: ' . DIR_FS_SQL_CACHE . '. Υǥ쥯ȥ꤬ޤSQLå嵡ǽưޤ');
  define('WARNING_SQL_CACHE_DIRECTORY_NOT_WRITEABLE', 'ٹ: SQLåǥ쥯ȥ˽񤭹ߤǤޤ: ' . DIR_FS_SQL_CACHE . '. ꤵޤSQLå嵡ǽưޤ');
  define('WARNING_DATABASE_VERSION_OUT_OF_DATE', 'ȤΥǡ١Patch Level夲ɬפ褦Ǥ->ɲꡦġ->СΥå patch levelǧƤ');


  define('TEXT_CCVAL_ERROR_INVALID_DATE', 'Ϥ줿쥸åȥɤͭ¤̵Ǥǧξ⤦ϤƤ');
  define('TEXT_CCVAL_ERROR_INVALID_NUMBER', 'Ϥ줿쥸åȥɤΥ̵ֹǤǧξ⤦ϤƤ');
  define('TEXT_CCVAL_ERROR_UNKNOWN_CARD', 'ֹκǽΣ: %s ְ㤤ǤʤСåפǤϤΥɤΤ갷Ǥޤֹ椬ְäƤ褦Ǥ⤦ϤƤ');

  define('BOX_INFORMATION_DISCOUNT_COUPONS', 'ݥ');
  define('BOX_INFORMATION_GV', TEXT_GV_NAME . ' 褯');
  define('VOUCHER_BALANCE', TEXT_GV_NAME . ' Ĺ ');
  define('BOX_HEADING_GIFT_VOUCHER', TEXT_GV_NAME . '');
  define('GV_FAQ', TEXT_GV_NAME . ' 褯');
  define('ERROR_REDEEMED_AMOUNT', 'ޤ');
  define('ERROR_NO_REDEEM_CODE', '' . TEXT_GV_REDEEM . 'ϤƤޤ');
  define('ERROR_NO_INVALID_REDEEM_GV', '̵' . TEXT_GV_NAME . ' ' . TEXT_GV_REDEEM . 'Ǥ');
  define('TABLE_HEADING_CREDIT', 'Ѳǽʥ쥸åȥ');
define('GV_HAS_VOUCHERA', 'ͤ' . TEXT_GV_NAME . 'Ȥ˻Ĺ⤬ޤ˾Ǥ <br />

                           λĹ <a class="pageResults" href="');
define('GV_HAS_VOUCHERB', '"><strong>E᡼</strong></a>');
define('ENTRY_AMOUNT_CHECK_ERROR', 'ζۤˤϻĹ⤬­Ƥޤ');
define('BOX_SEND_TO_FRIEND', ' ' . TEXT_GV_NAME . '£');

  define('VOUCHER_REDEEMED',  TEXT_GV_NAME . 'ޤ');
  define('CART_COUPON', 'ݥ :');
  define('CART_COUPON_INFO', '˾ܤ');
  define('TEXT_SEND_OR_SPEND','ͤ' . TEXT_GV_NAME . 'Ȥ˻Ĺ⤬ޤ ȤȤ⡢ɤʤ뤳ȤǤޤϲΥܥ򥯥åƤ');
  define('TEXT_BALANCE_IS', 'ͤ' . TEXT_GV_NAME . 'Ĺ: ');
  define('TEXT_AVAILABLE_BALANCE', 'ͤ' . TEXT_GV_NAME . '');

// payment method is GV/Discount
  define('PAYMENT_METHOD_GV', 'եȷ/ݥ');
  define('PAYMENT_MODULE_GV', 'GV/DC');

  define('TABLE_HEADING_CREDIT_PAYMENT', 'Ѳǽʥ쥸åȥ');

  define('TEXT_INVALID_REDEEM_COUPON', '̵ʥݥ󥳡ɤǤ');
  define('TEXT_INVALID_REDEEM_COUPON_MINIMUM', 'Υݥ %s ߰ʾΤ㤤ʪǤѤޤ');
  define('TEXT_INVALID_STARTDATE_COUPON', 'ΥݥϤޤȤޤ');
  define('TEXT_INVALID_FINISDATE_COUPON', 'Υݥͭ¤ڤƤޤ');
  define('TEXT_INVALID_USES_COUPON', 'ΥݥƤΤͤΤѲιפǺ ');
  define('TIMES', ' ޤǤΤѤˤʤäƤޤ');
  define('TIME', '  ޤǤΤѤˤʤäƤޤ');
  define('TEXT_INVALID_USES_USER_COUPON', 'ݥ󥳡: %s ϴ˺ѲãƤޤΥݥϤͤȤ˺ ');
  define('REDEEMED_COUPON', ' ');
  define('REDEEMED_MIN_ORDER', '߰ʾΤʸ');
  define('REDEEMED_RESTRICTIONS', ' [ʥƥ꤬ꤵޤ]');
  define('TEXT_ERROR', '顼ޤ');
  define('TEXT_INVALID_COUPON_PRODUCT', 'ߥȤäƤ뾦ʤǤΥݥ󥳡ɤ򤪻ȤΤޤ');
  define('TEXT_VALID_COUPON', 'ݥޤ');

// more info in place of buy now
  define('MORE_INFO_TEXT','...ܺ');

// IP Address
  define('TEXT_YOUR_IP_ADDRESS','IPɥ쥹: ');

//Generic Address Heading
  define('HEADING_ADDRESS_INFORMATION','ɥ쥹');

// cart contents
  define('PRODUCTS_ORDER_QTY_TEXT_IN_CART','ο: ');
  define('PRODUCTS_ORDER_QTY_TEXT','Ȥ: ');

  define('TEXT_PRODUCT_WEIGHT_UNIT','kg');

// Shipping
  define('TEXT_SHIPPING_WEIGHT','kg');
  define('TEXT_SHIPPING_BOXES', 'ĸ');

// Discount Savings
  define('PRODUCT_PRICE_DISCOUNT_PREFIX',':&nbsp;');
  define('PRODUCT_PRICE_DISCOUNT_PERCENTAGE','%OFF');
  define('PRODUCT_PRICE_DISCOUNT_AMOUNT','&nbsp;OFF');

// Sale Maker Sale Price
  define('PRODUCT_PRICE_SALE','ò:&nbsp;');

//universal symbols
  define('TEXT_NUMBER_SYMBOL', '# ');

// banner_box
  define('BOX_HEADING_BANNER_BOX','ݥ󥵡');
  define('TEXT_BANNER_BOX','åפΥݥ󥵡ˤ⤪Ω꤯');

// banner box 2
  define('BOX_HEADING_BANNER_BOX2','¸Ǥ?');
  define('TEXT_BANNER_BOX2','åƤ!');

// banner_box - all
  define('BOX_HEADING_BANNER_BOX_ALL','ݥ󥵡');
  define('TEXT_BANNER_BOX_ALL','åפΥݥ󥵡ˤ⤪Ω꤯');

// boxes defines
  define('PULL_DOWN_ALL','򤷤Ƥ');
  define('PULL_DOWN_MANUFACTURERS','- ꥻå -');
// shipping estimator
  define('PULL_DOWN_SHIPPING_ESTIMATOR_SELECT', '򤷤Ƥ');

// general Sort By
  define('TEXT_INFO_SORT_BY','ɽ: ');

// close window image popups
  define('TEXT_CLOSE_WINDOW',' - ɥĤ');
// close popups
  define('TEXT_CURRENT_CLOSE_WINDOW','[ ɥĤ ]');

// iii 031104 added:  File upload error strings
  define('ERROR_FILETYPE_NOT_ALLOWED', '顼: Υե륿פϵĤƤޤ');
  define('WARNING_NO_FILE_UPLOADED', 'ٹ:  ⥢åץɤƤޤ');
  define('SUCCESS_FILE_SAVED_SUCCESSFULLY', ':  ե뤬¸ޤ');
  define('ERROR_FILE_NOT_SAVED', '顼:  ե뤬¸Ƥޤ');
  define('ERROR_DESTINATION_NOT_WRITEABLE', '顼:  ¸ǥ쥯ȥ꤬񤭹߲ǽˤʤäƤޤ');
  define('ERROR_DESTINATION_DOES_NOT_EXIST', '顼: ¸ǥ쥯ȥ꤬¸ߤޤ');
// End iii added

  define('TEXT_BEFORE_DOWN_FOR_MAINTENANCE', 'Τ餻: ƥʥ󥹺ȤΤޤʤȤٻߤޤͽ');
  define('TEXT_ADMIN_DOWN_FOR_MAINTENANCE', 'Τ餻: ޥƥʥ󥹺ȤΤ᥵ȤٻߤƤޤ');

  define('PRODUCTS_PRICE_IS_FREE_TEXT','̵Ǥ!');
  define('PRODUCTS_PRICE_IS_CALL_FOR_PRICE_TEXT','ʤ䤤碌');
  define('TEXT_CALL_FOR_PRICE','ʤ䤤碌');

  define('TEXT_INVALID_SELECTION',' ̵Ǥ:  ');
  define('TEXT_ERROR_OPTION_FOR',' ץ: ');
  define('TEXT_INVALID_USER_INPUT', 'ϤƤ<br />');

// product_listing
  define('PRODUCTS_QUANTITY_MIN_TEXT_LISTING','Ǿ:');
  define('PRODUCTS_QUANTITY_UNIT_TEXT_LISTING','ñ:');
  define('PRODUCTS_QUANTITY_IN_CART_LISTING','Ȥ:');
  define('PRODUCTS_QUANTITY_ADD_ADDITIONAL_LISTING','ɲä:');

  define('PRODUCTS_QUANTITY_MAX_TEXT_LISTING',':');

  define('TEXT_PRODUCTS_MIX_OFF','*ץʣԲ');
  define('TEXT_PRODUCTS_MIX_ON','ץʣ');

  define('TEXT_PRODUCTS_MIX_OFF_SHOPPING_CART','*ñ⥪ץʣԲ<br />');
  define('TEXT_PRODUCTS_MIX_ON_SHOPPING_CART','*ñ⥪ץʣ<br />');

  define('ERROR_MAXIMUM_QTY','̤ѹޤ - ٤ˤᤤȤäƤޤ ');
  define('ERROR_CORRECTIONS_HEADING','Ƥ: <br />');

// Downloads Controller
  define('DOWNLOADS_CONTROLLER_ON_HOLD_MSG',':ʧλޤǾʤΥɤϤǤޤ');
  define('TEXT_FILESIZE_BYTES', ' bytes');
  define('TEXT_FILESIZE_MEGS', ' MB');

// shopping cart errors
  define('ERROR_PRODUCT','̾: ');
  define('ERROR_PRODUCT_STATUS_SHOPPING_CART','<br />ˤξʤϸ߼갷äƤޤ<br />åԥ󥰥ȤƤޤ');
  define('ERROR_PRODUCT_QUANTITY_MIN',' ... ǾĿ顼 - ');
  define('ERROR_PRODUCT_QUANTITY_UNITS',' ... ñ̥顼 - ');
  define('ERROR_PRODUCT_OPTION_SELECTION','<br /> ... ̵ʥץ򤵤Ƥޤ ');
  define('ERROR_PRODUCT_QUANTITY_ORDERED','<br /> ʸ: ');
  define('ERROR_PRODUCT_QUANTITY_MAX',' ... Ŀ顼 - ');
  define('ERROR_PRODUCT_QUANTITY_MIN_SHOPPING_CART',' ... ǾĿ顼 - ');
  define('ERROR_PRODUCT_QUANTITY_UNITS_SHOPPING_CART',' ... ñ̥顼 - ');
  define('ERROR_PRODUCT_QUANTITY_MAX_SHOPPING_CART',' ... Ŀ顼 - ');

  define('TABLE_HEADING_FEATURED_PRODUCTS','ᾦ');

  define('TABLE_HEADING_NEW_PRODUCTS', '%sο徦');
  define('TABLE_HEADING_UPCOMING_PRODUCTS', 'ͽ꾦');
  define('TABLE_HEADING_DATE_EXPECTED', 'ͽ');
  define('TABLE_HEADING_SPECIALS_INDEX', '%s: ò');

// meta tags special defines
  define('META_TAG_PRODUCTS_PRICE_IS_FREE_TEXT','̵!');

// customer login
  define('TEXT_SHOWCASE_ONLY','䤤碌');
// set for login for prices
  define('TEXT_LOGIN_FOR_PRICE_PRICE','ʤϥ');
  define('TEXT_LOGIN_FOR_PRICE_BUTTON_REPLACE','ʤˤʤˤϥ󤷤Ƥ');
// set for show room only
  define('TEXT_LOGIN_FOR_PRICE_PRICE_SHOWROOM', ''); 
// blank for prices or enter your own text
  define('TEXT_LOGIN_FOR_PRICE_BUTTON_REPLACE_SHOWROOM','Τ');

// authorization pending
  define('TEXT_AUTHORIZATION_PENDING_PRICE', 'ʤϥ');
  define('TEXT_AUTHORIZATION_PENDING_BUTTON_REPLACE', 'ǧ³');
  define('TEXT_LOGIN_TO_SHOP_BUTTON_REPLACE','');

// text pricing
  define('TEXT_CHARGES_WORD','ۤη׻:');
  define('TEXT_PER_WORD','<br />1ĤθˤĤ: ');
  define('TEXT_WORDS_FREE',' ̵ ');
  define('TEXT_CHARGES_LETTERS','ۤη׻:');
  define('TEXT_PER_LETTER','<br />1ʸˤĤ: ');
  define('TEXT_LETTERS_FREE',' ̵ʸ');
  define('TEXT_ONETIME_CHARGES','* = ');
  define('TEXT_ONETIME_CHARGES_EMAIL',"?t" . '* = ');
  define('TEXT_ATTRIBUTES_QTY_PRICES_HELP', 'Ͱ');
  define('TABLE_ATTRIBUTES_QTY_PRICE_QTY','');
  define('TABLE_ATTRIBUTES_QTY_PRICE_PRICE','');
  define('TEXT_ATTRIBUTES_QTY_PRICES_ONETIME_HELP', 'ܿͰ');

// textarea attribute input fields
  define('TEXT_MAXIMUM_CHARACTERS_ALLOWED',' ʸ');
  define('TEXT_REMAINING','Ĥ');

// Shipping Estimator
  define('CART_SHIPPING_OPTIONS', '׻');
  define('CART_SHIPPING_OPTIONS_LOGIN', 'ɽˤ<a href="' . zen_href_link(FILENAME_LOGIN, '', 'SSL') . '"><span class="pseudolink"></span></a>Ƥ');
  define('CART_SHIPPING_METHOD_TEXT', 'ˡ');
  define('CART_SHIPPING_METHOD_RATES', '');
  define('CART_SHIPPING_METHOD_TO',': ');
  define('CART_SHIPPING_METHOD_TO_NOLOGIN', ': <a href="' . zen_href_link(FILENAME_LOGIN, '', 'SSL') . '"><span class="pseudolink"></span></a>');
  define('CART_SHIPPING_METHOD_FREE_TEXT','̵');
  define('CART_SHIPPING_METHOD_ALL_DOWNLOADS','- ');
  define('CART_SHIPPING_METHOD_RECALCULATE','Ʒ׻');
  define('CART_SHIPPING_METHOD_ZIP_REQUIRED','true');
  define('CART_SHIPPING_METHOD_ADDRESS',':');
  define('CART_OT','׶ۤѤ:');
  define('CART_OT_SHOW','true'); // set to false if you don't want order totals
  define('CART_ITEMS','Ȥ: ');
  define('CART_SELECT','');
  define('ERROR_CART_UPDATE', 'ʸƤ򹹿Ƥ ...<br />');
  define('IMAGE_BUTTON_UPDATE_CART', 'ȤƤ򹹿');

// multiple product add to cart
  define('TEXT_PRODUCT_LISTING_MULTIPLE_ADD_TO_CART', 'ɲ: ');
  define('TEXT_PRODUCT_ALL_LISTING_MULTIPLE_ADD_TO_CART', 'ɲ: ');
  define('TEXT_PRODUCT_FEATURED_LISTING_MULTIPLE_ADD_TO_CART', 'ɲ: ');
  define('TEXT_PRODUCT_NEW_LISTING_MULTIPLE_ADD_TO_CART', 'ɲ: ');
  //moved SUBMIT_BUTTON_ADD_PRODUCTS_TO_CART to button_names.php as BUTTON_ADD_PRODUCTS_TO_CART_ALT

// discount qty table
  define('TEXT_HEADER_DISCOUNT_PRICES_PERCENTAGE', '̳');
  define('TEXT_HEADER_DISCOUNT_PRICES_ACTUAL_PRICE', '̳ŬѸ');
  define('TEXT_HEADER_DISCOUNT_PRICES_AMOUNT_OFF', '̳');
  define('TEXT_FOOTER_DISCOUNT_QUANTITIES', '* ɽץˤۤʤޤ');
  define('TEXT_HEADER_DISCOUNTS_OFF', '̳ϤѤޤ...');

// sort order titles for dropdowns
  define('PULL_DOWN_ALL_RESET','- ꥻå - ');
  define('TEXT_INFO_SORT_BY_PRODUCTS_NAME', '̾');
  define('TEXT_INFO_SORT_BY_PRODUCTS_NAME_DESC', '̾ - ߽');
  define('TEXT_INFO_SORT_BY_PRODUCTS_PRICE', ' - ');
  define('TEXT_INFO_SORT_BY_PRODUCTS_PRICE_DESC', ' - ');
  define('TEXT_INFO_SORT_BY_PRODUCTS_MODEL', 'ǥ');
  define('TEXT_INFO_SORT_BY_PRODUCTS_DATE_DESC', 'Ͽ - ');
  define('TEXT_INFO_SORT_BY_PRODUCTS_DATE', 'Ͽ - ');
  define('TEXT_INFO_SORT_BY_PRODUCTS_SORT_ORDER', 'ɽ');

// downloads module defines
  define('TABLE_HEADING_DOWNLOAD_DATE', 'ͭ');
  define('TABLE_HEADING_DOWNLOAD_COUNT', 'Ĥ');
  define('HEADING_DOWNLOAD', 'եɤˤϥɥܥ򲡤ƥݥåץåץ˥塼֥ǥ¸פ򤷤Ƥ');
  define('TABLE_HEADING_DOWNLOAD_FILENAME','ե̾');
  define('TABLE_HEADING_PRODUCT_NAME','̾');
  define('TABLE_HEADING_BYTE_SIZE','ե륵');
  define('TEXT_DOWNLOADS_UNLIMITED', '̵');
  define('TEXT_DOWNLOADS_UNLIMITED_COUNT', '--- *** ---');

// misc
  define('COLON_SPACER', ':&nbsp;&nbsp;');

// table headings for cart display and upcoming products
  define('TABLE_HEADING_QUANTITY', '.');
  define('TABLE_HEADING_PRODUCTS', '̾');
  define('TABLE_HEADING_TOTAL', '');

// create account - login shared
  define('TABLE_HEADING_PRIVACY_CONDITIONS', 'Ŀ;ݸ');
  define('TEXT_PRIVACY_CONDITIONS_DESCRIPTION', 'ҤθĿ;ݸˤƱդϥåܥå򥯥åƤĿ;ݸˤ<a href="' . zen_href_link(FILENAME_PRIVACY, '', 'SSL') . '"><span class="pseudolink"></span></a>');
  define('TEXT_PRIVACY_CONDITIONS_CONFIRM', 'Ŀ;ݸˤƱդޤ');
  define('TABLE_HEADING_ADDRESS_DETAILS', '');
  define('TABLE_HEADING_PHONE_FAX_DETAILS', 'Ϣ');
  define('TABLE_HEADING_DATE_OF_BIRTH', 'ǯγǧ');
  define('TABLE_HEADING_LOGIN_DETAILS', '');
  define('TABLE_HEADING_REFERRAL_DETAILS', 'ҲǤ?');

  define('ENTRY_EMAIL_PREFERENCE','˥塼쥿E᡼ˤĤ');
  define('ENTRY_EMAIL_HTML_DISPLAY','HTML');
  define('ENTRY_EMAIL_TEXT_DISPLAY','ƥȷ');
  define('EMAIL_SEND_FAILED','顼: E᡼˼Ԥޤ: "%s" <%s> ̾: "%s"');

  define('DB_ERROR_NOT_CONNECTED', '顼 - ǡ١³Ǥޤ');

// EZ-PAGES Alerts
  define('TEXT_EZPAGES_STATUS_HEADER_ADMIN', 'ٹ: EZ-PAGES إå - IPɽ');
  define('TEXT_EZPAGES_STATUS_FOOTER_ADMIN', 'ٹ: EZ-PAGES եå - IPɽ');
  define('TEXT_EZPAGES_STATUS_SIDEBOX_ADMIN', 'ٹ: EZ-PAGES ɥܥå - IPɽ');


///////////////////////////////////////////////////////////
// include email extras
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_EMAIL_EXTRAS)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_EMAIL_EXTRAS);

// include template specific header defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_HEADER)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_HEADER);

// include template specific button name defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_BUTTON_NAMES)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_BUTTON_NAMES);

// include template specific icon name defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_ICON_NAMES)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_ICON_NAMES);

// include template specific other image name defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_OTHER_IMAGES_NAMES)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_OTHER_IMAGES_NAMES);

// credit cards
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_CREDIT_CARDS)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select. FILENAME_CREDIT_CARDS);

// include template specific whos_online sidebox defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_WHOS_ONLINE . '.php')) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_WHOS_ONLINE . '.php');

// include template specific meta tags defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/meta_tags.php')) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . 'meta_tags.php');

// END OF EXTERNAL LANGUAGE LINKS
?>
