import java.io.*;
import java.util.*;

/*
 * Main.java
 *
 * Created on 2003/11/13, 18:18
 */

/**
 * @author  kumano
 */
public class Main {

	private static MapFrame frame;
	private static Map maps;

	/**
	 * @param args the command line arguments
	 */
	public static void main(String[] args) throws Exception {
		maps = new HashMap();

		frame = new MapFrame();
		frame.show();
		MapPanel panel = (MapPanel) frame.shapePanel;

		String baseDir = "data";
		String files[] = new File(baseDir).list();
		for (int i = 0; i < files.length; i++) {
			String mapName = files[i].toLowerCase();
			maps.put(mapName, new MapData(baseDir, mapName));
		}

		panel.addMapListener(new MapListener() {
			public void mapZoomChanged(MapEvent e) {
				loadMap();
			}

			public void mapMoved(MapEvent e) {
				loadMap();
			}
		});

		panel.drawMap(maps);
		panel.zoom(0.06);
		panel.moveToCenter();
		loadMap();
		panel.repaint();
	}

	public static void loadMap() {
		double zoom = ((MapPanel) frame.shapePanel).getZoom();
		for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
			Map.Entry entry = (Map.Entry) iter.next();
			MapData mapData = ((MapData) entry.getValue());
			if (((MapPanel) frame.shapePanel).getVisibleArea().intersects(mapData.getRectangle())) {
				try {
					if (zoom > 0.05) {
						if (!mapData.hasGyousei()) {
							System.out.println("loading " + entry.getKey() + "...");
							mapData.loadGyousei();
							frame.shapePanel.repaint();
						}
					} else {
					}
				} catch (Exception exception) {
					System.err.println("failed to load " + entry.getKey());
					exception.printStackTrace(System.err);
				}
			} else {
				if (mapData.hasGyousei()) {
					System.out.println("freed " + entry.getKey());
					mapData.freeGyousei();
				}
			}
		}
		try {
			((MapPanel) frame.shapePanel).drawMap(maps);
		} catch (Exception exception) {
			System.err.println("failed to draw map");
			exception.printStackTrace(System.err);
		}
	}
}
