import java.awt.geom.Rectangle2D;
import java.util.*;

/*
 * : 2003/12/13
 */

/**
 * ϿޤХå饦ɤɤ߹ॹåɤǤ
 * @author Kumano Tatsuo
 */
class LoadMapThread extends Thread {

	public static void main(String[] args) {
	}

	private double keepCoefficient; // ̲ʬΥǡ¸Ƥ
	private Map maps;
	private MapPanel panel;
	private double preLoadCoefficient; // ̲ʬΥǡɤߤ뤫

	LoadMapThread(Map maps, MapPanel panel) {
		this.maps = maps;
		this.panel = panel;
		preLoadCoefficient = 1;
		keepCoefficient = 2;
	}

	public void run() {
		while (true) {
			try {
				double zoom = ((MapPanel) panel).getZoom();
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					Map.Entry entry = (Map.Entry) iter.next();
					MapData mapData = ((MapData) entry.getValue());
					if (panel.isIdle()) {
						Rectangle2D visibleRectangle = ((MapPanel) panel).getVisibleArea();
						Rectangle2D preLoadRectangle =
							new Rectangle2D.Double(
								visibleRectangle.getX() - visibleRectangle.getWidth() * preLoadCoefficient,
								visibleRectangle.getY() - visibleRectangle.getHeight() * preLoadCoefficient,
								visibleRectangle.getWidth() + visibleRectangle.getWidth() * preLoadCoefficient * 2,
								visibleRectangle.getHeight() + visibleRectangle.getHeight() * preLoadCoefficient * 2);
						Rectangle2D keepRectangle =
							new Rectangle2D.Double(
								visibleRectangle.getX() - visibleRectangle.getWidth() * keepCoefficient,
								visibleRectangle.getY() - visibleRectangle.getHeight() * keepCoefficient,
								visibleRectangle.getWidth() + visibleRectangle.getWidth() * keepCoefficient * 2,
								visibleRectangle.getHeight() + visibleRectangle.getHeight() * keepCoefficient * 2);
						if (preLoadRectangle.intersects(mapData.getBounds())) {
							// ǡɤ߹
							if (zoom > 0.05) {
								boolean isChanged = false;
								if (!mapData.hasGyousei()) {
									mapData.loadGyousei();
									isChanged = true;
								}
								if (!mapData.hasSi_tyo()) {
									mapData.loadSi_tyo();
									isChanged = true;
								}
								if (!mapData.hasTyome()) {
									mapData.loadTyome();
									isChanged = true;
								}
								if (visibleRectangle.intersects(mapData.getBounds()) && isChanged) {
									panel.repaint();
								}
							}
						} else if (!keepRectangle.intersects(mapData.getBounds())) {
							// ǡ
							if (mapData.hasGyousei()) {
								mapData.freeGyousei();
							}
							if (mapData.hasSi_tyo()) {
								mapData.freeSi_tyo();
							}
							if(mapData.hasTyome()){
								mapData.freeTyome();
							}
						}
					}
				}
				Thread.sleep(1000);
			} catch (Exception exception) {
				System.err.println("Failed to load map.");
				exception.printStackTrace(System.err);
			}
			((MapPanel) panel).setMapData(maps);
		}
	}

}
