import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*;

import javax.swing.*;

/**
 * Ͽޤѥͥ褹륯饹Ǥ
 */
public class MapPanel extends JPanel {
	private Map maps;
	private boolean isZoomChanged; // Ψѹ줿ɤ
	private double lastHeight; // ľι⤵
	private double lastMouseX; // ľΥޥɸ
	private double lastMouseY; // ľΥޥɸ
	private double lastWidth; // ľ
	private MapListener mapListener = null;
	private double maxX;
	private double maxY;
	private double minX;
	private double minY;
	private double offsetX; // եå(ºɸ)
	private double offsetY; // եå(ºɸ)
	private double zoom; // ɽΨ
	private boolean isIdle; // 桼ʤ֤ɤ

	/**
	 * 󥹥ȥ饯Ǥ
	 * ե졼Υꤷޤ
	 */
	public MapPanel() {
		setBackground(Color.white);
		offsetX = 0;
		offsetY = 0;
		zoom = 1;
		isZoomChanged = true;
		lastMouseX = offsetX;
		lastMouseY = offsetY;
		lastWidth = getWidth();
		lastHeight = getHeight();
		setIdle(true);
		addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				lastMouseX = e.getX();
				lastMouseY = e.getY();
				setIdle(false);
			}
			public void mouseReleased(MouseEvent e) {
				setIdle(true);
			}
		});
		addMouseMotionListener(new MouseMotionAdapter() {
			public void mouseDragged(MouseEvent e) {
				offsetX -= e.getX() - lastMouseX;
				offsetY -= e.getY() - lastMouseY;
				lastMouseX = e.getX();
				lastMouseY = e.getY();
				repaint();
				if (mapListener != null) {
					mapListener.mapMoved(new MapEvent(this));
				}
			}
		});
		addMouseWheelListener(new MouseWheelListener() {
			public void mouseWheelMoved(MouseWheelEvent e) {
				double newZoom = zoom * (1 + (double) e.getWheelRotation() / 20);
				double newX = (offsetX + e.getX()) / zoom * newZoom - e.getX();
				double newY = (offsetY + e.getY()) / zoom * newZoom - e.getY();
				offsetX = newX;
				offsetY = newY;
				zoom = newZoom;
				isZoomChanged = true;
				repaint();
				if (mapListener != null) {
					mapListener.mapZoomChanged(new MapEvent(this));
				}
			}
		});
		addComponentListener(new ComponentAdapter() {
			public void componentResized(ComponentEvent e) {
				double newZoomX = zoom * getWidth() / lastWidth;
				double newZoomY = zoom * getHeight() / lastHeight;
				double newZoom = Math.sqrt(newZoomX * newZoomY);
				double newOffsetX = offsetX * newZoom / zoom;
				double newOffsetY = offsetY * newZoom / zoom;
				lastWidth = getWidth();
				lastHeight = getHeight();
				offsetX = newOffsetX;
				offsetY = newOffsetY;
				zoom = newZoom;
				isZoomChanged = true;
				if (mapListener != null) {
					mapListener.mapZoomChanged(new MapEvent(this));
				}
			}
		});
	}

	/**
	 * Υե졼फ桼٥Ȥ뤿ˡꤵ줿ޥåץꥹʤɲäޤ
	 * l  null ξ硢㳰ϥ줺¹Ԥޤ
	 * @param l ޥåץꥹ
	 */
	public void addMapListener(MapListener l) {
		mapListener = l;
	}

	/**
	 * @param maps maps (String -> MapData)
	 */
	public void setMapData(Map maps) {
		this.maps = maps;
	}

	/**
	 * @return
	 */
	public double getMaxX() {
		return maxX;
	}

	/**
	 * @return
	 */
	public double getMaxY() {
		return maxY;
	}

	/**
	 * @return
	 */
	public double getMinX() {
		return minX;
	}

	/**
	 * @return
	 */
	public double getMinY() {
		return minY;
	}

	/**
	 * ֥Ȥ¸ߤϰϤޤ
	 * @return ֥Ȥ¸ߤϰ
	 */
	public Rectangle2D getObjectArea() {
		return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
	}

	/**
	 * ɽƤϰϤޤ
	 * @return ɽƤϰ
	 */
	public Rectangle2D getVisibleArea() {
		return new Rectangle2D.Double(offsetX / zoom, offsetY / zoom, getWidth() / zoom, getHeight() / zoom);
	}

	/**
	 * Ψޤ
	 * @return Ψ
	 */
	public double getZoom() {
		return zoom;
	}

	/**
	 * ꤷ֥Ȥɽꥢˤ뤫ɤޤ
	 * @param shape ֥
	 * @return ꤷ֥Ȥɽꥢˤ뤫ɤ
	 */
	public boolean isVisible(Shape shape) {
		return shape.intersects(getVisibleArea());
	}

	/**
	 * Ψѹ줿ɤޤ
	 * @return Ψѹ줿ɤ
	 */
	public boolean isZoomChanged() {
		if (isZoomChanged) {
			isZoomChanged = false;
			return true;
		} else {
			return false;
		}
	}

	public void moveToCenter() {
		calcMinMaxXY();
		offsetX = (minX + maxX) / 2 * zoom - getWidth() / 2;
		offsetY = (minY + maxY) / 2 * zoom - getHeight() / 2;
	}

	private void calcMinMaxXY() {
		minX = Double.POSITIVE_INFINITY;
		minY = Double.POSITIVE_INFINITY;
		maxX = Double.NEGATIVE_INFINITY;
		maxY = Double.NEGATIVE_INFINITY;
		if (maps != null) {
			for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
				MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
				Rectangle2D bounds = mapData.getBounds();
				if (bounds.getMinX() < minX) {
					minX = bounds.getMinX();
				}
				if (bounds.getMinY() < minY) {
					minY = bounds.getMinY();
				}
				if (maxX < bounds.getMaxX()) {
					maxX = bounds.getMaxX();
				}
				if (maxY < bounds.getMaxY()) {
					maxY = bounds.getMaxY();
				}
			}
		}
	}

	/**
	 * ե졼ब褵˸ƤӽФޤ
	 */
	public void paint(Graphics g) {
		Image image = createImage(getWidth(), getHeight());
		Graphics2D g2 = (Graphics2D) image.getGraphics();
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2.setColor(Color.WHITE);
		g2.fillRect(0, 0, getWidth(), getHeight());
		g2.translate(-offsetX, -offsetY);
		g2.scale(zoom, zoom);
		double x = offsetX / zoom;
		double y = offsetY / zoom;
		double w = getWidth() / zoom;
		double h = getHeight() / zoom;
		Font font = new Font("default", Font.PLAIN, 30);
		try {
			if (maps != null) {
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					// 褹
					if (mapData.getBounds().intersects(x, y, w, h)) {
						if (mapData.hasSi_tyo()) {
							for (Iterator iter2 = mapData.getSi_tyo().keySet().iterator(); iter2.hasNext();) {
								Polygon polygon = ((Polygon) mapData.getSi_tyo().get(iter2.next()));
								if (polygon.getType() == Polygon.TYPE_SHI_KU_CHO_SON) {
									g2.setColor(new Color(250, 250, 240));
									g2.fill(polygon.getPath());
								}
							}
						}
						if (mapData.hasGyousei()) {
							for (Iterator iter2 = mapData.getGyousei().keySet().iterator(); iter2.hasNext();) {
								Arc arc = ((Arc) mapData.getGyousei().get(iter2.next()));
								if (arc.getTag() != Arc.TAG_DETACHED
									&& arc.getTag() != Arc.TAG_EDGE_OF_MAP
									&& arc.getTag() != Arc.TAG_EDGE_OF_WORLD) {
									if (arc.getType() == Arc.TYPE_GYOUSEI_PREFECTURE
										|| arc.getType() == Arc.TYPE_GYOUSEI_CITY) {
										g2.setColor(Color.BLACK);
										g2.setStroke(new BasicStroke(4.0f));
									} else {
										g2.setColor(Color.GRAY);
										g2.setStroke(new BasicStroke(1.0f));
									}
									g2.draw(arc.getPath());
								}
							}
						}
						if (!mapData.hasGyousei() && !mapData.hasTyome() && !mapData.hasSi_tyo()) {
							g2.setColor(Color.GRAY);
							g2.draw(mapData.getBounds());
						}
					}
				}
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					MapData mapData = (MapData) ((Map.Entry) iter.next()).getValue();
					// ٥褹
					if (mapData.hasTyome()) {
						for (Iterator iter2 = mapData.getTyome().keySet().iterator(); iter2.hasNext();) {
							Polygon polygon = ((Polygon) mapData.getTyome().get(iter2.next()));
							if (polygon.getType() == Polygon.TYPE_OAZA_CHOME) {
								if(polygon.getAttribute()!=null){
									g2.setColor(Color.BLACK);
									g2.setFont(font);
									FontMetrics metrics = this.getFontMetrics(font);
									g2.drawString(
												  polygon.getAttribute(),
												  (float) polygon.getX() - metrics.stringWidth(polygon.getAttribute()) / 2,
												  (float) polygon.getY() - metrics.getHeight() / 2);
								}
							}
						}
					}
				}
			}
		} catch (Exception e) {
			System.err.println("Failed to draw map.");
			e.printStackTrace(System.err);
		}
		g.drawImage(image, 0, 0, this);
	}

	/**
	 * ºɸޤ
	 * NOT CERTIFIED
	 * @param location ۺɸ
	 * @return ºɸ
	 */
	public Point2D toRealLocation(Point2D location) {
		return new Point2D.Double(location.getX() * zoom - offsetX, location.getY() * zoom - offsetY);
	}

	/**
	 * ۺɸޤ
	 * @param location ºɸ
	 * @return ۺɸ
	 */
	public Point2D toVirtualLocation(Point2D location) {
		return new Point2D.Double((offsetX + location.getX()) / zoom, (offsetY + location.getY()) / zoom);
	}

	public void zoom(double zoom) {
		this.zoom = zoom;
		isZoomChanged = true;
		if (mapListener != null) {
			mapListener.mapZoomChanged(new MapEvent(this));
		}
	}

	public void zoomAutomaticaly() {
		calcMinMaxXY();
		double zoomX = getWidth() / (maxX - minX);
		double zoomY = getHeight() / (maxY - minY);
		if (zoomY < zoomX) {
			zoom = zoomY * 0.9;
		} else {
			zoom = zoomX * 0.9;
		}
		isZoomChanged = true;
		if (mapListener != null) {
			mapListener.mapZoomChanged(new MapEvent(this));
		}
	}

	/**
	 * @param b
	 */
	public void setIdle(boolean b) {
		isIdle = b;
	}

	/**
	 * @return
	 */
	public boolean isIdle() {
		return isIdle;
	}

}
