package map;
import java.awt.geom.Rectangle2D;
import java.util.Map;

/**
 * 地図を読み込むクラスです。
 * @author Kumano Tatsuo
 * 作成日: 2004/01/09
 */
class LoadMap {
    /**
     * 変更されたかどうか
     */
    private boolean isChanged;

    /** 地図を読み込む必要があれば読み込み、開放する必要があれば開放します。
     * このメソッドを呼び出した直後に isChanged() を呼び出すと、
     * このメソッドによって地図の状態が変化したかどうかが取得できます。
     * @param maps 地図
     * @param panel パネル
     * @throws Exception
     */
    void loadMap(Map<String, MapData> maps, MapPanel panel) throws Exception {
        double zoom = panel.getZoom();
        this.isChanged = false;
        for (MapData mapData : maps.values()) {
            if (panel.isIdle()) {
                Rectangle2D visibleRectangle = ((MapPanel) panel).getVisibleRectangle();
                Rectangle2D preLoadRectangle = new Rectangle2D.Double(visibleRectangle.getX()
                        - (visibleRectangle.getWidth() * Const.preLoadCoefficient), visibleRectangle
                        .getY()
                        - (visibleRectangle.getHeight() * Const.preLoadCoefficient), visibleRectangle
                        .getWidth()
                        + (visibleRectangle.getWidth() * Const.preLoadCoefficient * 2), visibleRectangle
                        .getHeight()
                        + (visibleRectangle.getHeight() * Const.preLoadCoefficient * 2));
                Rectangle2D keepRectangle = new Rectangle2D.Double(visibleRectangle.getX()
                        - (visibleRectangle.getWidth() * Const.keepCoefficient), visibleRectangle.getY()
                        - (visibleRectangle.getHeight() * Const.keepCoefficient), visibleRectangle
                        .getWidth()
                        + (visibleRectangle.getWidth() * Const.keepCoefficient * 2), visibleRectangle
                        .getHeight()
                        + (visibleRectangle.getHeight() * Const.keepCoefficient * 2));
                // 駅と鉄道のデータを読み込む
                if (!mapData.hasEki()) {
                    mapData.loadEki();
                    this.isChanged = true;
                }
                // データを開放する
                if (zoom < Const.loadGyouseiZoom) {
                    if (mapData.hasGyousei()) {
                        mapData.freeSi_tyo();
                        mapData.freeTyome();
                        mapData.freeGyousei();
                        this.isChanged = true;
                    }
                }
                if (zoom < Const.loadOtherZoom) {
                    if (mapData.hasRoadArc()) {
                        mapData.freeRoadArc();
                        this.isChanged = true;
                    }
                    if (mapData.hasMizuArc()) {
                        mapData.freeMizu();
                        mapData.freeMizuArc();
                        this.isChanged = true;
                    }
                    if (mapData.hasTatemonoArc()) {
                        mapData.freeTatemono();
                        mapData.freeTatemonoArc();
                        this.isChanged = true;
                    }
                    if (mapData.hasZyouti()) {
                        mapData.freeZyouti();
                        this.isChanged = true;
                    }
                }
                if (preLoadRectangle.intersects(mapData.getBounds())) {
                    // データを読み込む
                    if (zoom > Const.loadGyouseiZoom) {
                        if (!mapData.hasGyousei()) {
                            mapData.loadGyousei();
                            //mapData.loadSi_tyo();
                            mapData.loadTyome();
                            this.isChanged = true;
                        }
                        if (!mapData.hasOthers()) {
                            mapData.loadOthers();
                            this.isChanged = true;
                        }
                    }
                    if (zoom > Const.loadOtherZoom) {
                        if (!mapData.hasRoadArc()) {
                            mapData.loadRoadArc();
                            this.isChanged = true;
                        }
                        if (!mapData.hasMizuArc()) {
                            mapData.loadMizuArc();
                            mapData.loadMizu();
                            this.isChanged = true;
                        }
                        if (!mapData.hasTatemonoArc()) {
                            mapData.loadTatemonoArc();
                            mapData.loadTatemono();
                            this.isChanged = true;
                        }
                        if (!mapData.hasZyouti()) {
                            mapData.loadZyouti();
                            this.isChanged = true;
                        }
                    }
                } else if (!keepRectangle.intersects(mapData.getBounds())) {
                    // データを開放する
                    if (mapData.hasGyousei()) {
                        mapData.freeSi_tyo();
                        mapData.freeTyome();
                        mapData.freeGyousei();
                    }
                    if (mapData.hasMizuArc()) {
                        mapData.freeMizu();
                        mapData.freeMizuArc();
                    }
                    if (mapData.hasOthers()) {
                        mapData.freeZyouti();
                    }
                    if (mapData.hasTatemonoArc()) {
                        mapData.freeTatemono();
                        mapData.freeTatemonoArc();
                    }
                    if (mapData.hasRoadArc()) {
                        mapData.freeRoadArc();
                    }
                }
            }
        }
    }

    /**
     * 直前の読み込みで、地図の状態が変化したかどうかを取得します。
     * @return 地図の状態が変化したかどうか
     */
    boolean isChanged() {
        return this.isChanged;
    }
}
