import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import map.BackgroundThread;
import map.Const;
import map.MapData;
import map.MapPanel;
import search.Search;
import cell.CellSearch;

/**
 * アプレット本体です。
 * @author Kumano Tatsuo
 * Created on 2005/05/03 14:17:15
 */
public class MainApplet extends Applet {

    /**
     * 初めて再描画が呼ばれたかどうか
     */
    private boolean isFirst;
    /**
     * 地図を表示するパネル
     */
    private MapPanel panel;
    /**
     * バックグラウンドで地図を読み込むスレッド 
     */
    private BackgroundThread backgroundThread;
    
    public void init() {
    }
    
    public void start() {
        try {
            Const.IS_OFFLINE = false;
            Const.SEPARATOR = "/";
            final Map<String, MapData> maps = new TreeMap<String, MapData>();
            final Search search = new CellSearch(2000, 1500);
            this.panel = new MapPanel(maps);
            this.setLayout(new BorderLayout());
            this.add(this.panel);
            System.out.println("Loading map infomation...");
            String baseDir = null;
            final List<String> list = new ArrayList<String>();
            if (Const.IS_OFFLINE) {
                throw new SecurityException("アプレットではローカルのファイルを読み込めません。");
            } else {
                final String documentBase = this.getDocumentBase().toString();
                if (documentBase.contains("?")) {
                    baseDir = Const.SERVER + documentBase.split("[?]")[1];
                } else {
                    baseDir = Const.SERVER + "kobe";
                }
                final URL url = new URL(baseDir);
                final Scanner scanner = new Scanner(new InputStreamReader(url.openStream(), "SJIS"));
                while (scanner.hasNextLine()) {
                    final String line = scanner.nextLine();
                    final Pattern pattern = Pattern
                            .compile("[0-9][0-9][a-zA-Z][a-zA-Z][0-9][0-9][0-9]");
                    final Matcher matcher = pattern.matcher(line);
                    if (matcher.find()) {
                        list.add(matcher.group().toLowerCase());
                    }
                }
                scanner.close();
            }
            for (final String mapName : list) {
                MapData map = new MapData(baseDir, mapName);
                maps.put(mapName, map);
                search.insert(map.getBounds(), mapName);
            }
            System.out.println("Map information loading finished.");
            this.panel.setSearch(search);
            this.backgroundThread = new BackgroundThread(maps, this.panel);
            this.isFirst = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void stop() {
    }

    public void paint(Graphics g) {
        if (this.isFirst) {
            this.panel.calcMinMaxXY();
            this.panel.zoomAutomaticaly();
            this.panel.moveToCenter();
            this.backgroundThread.start();
            this.isFirst = false;
        }
        this.panel.setNeedsRepaint(true);
        this.panel.repaint();
    }
    
}
