import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 三井住友銀行の住所を取得するプログラムです。
 * @author Kumano Tatsuo
 * 2005/11/27
 */
public class SMBC {
	/**
	 * メインメソッドです。
	 * @param args コマンドライン引数
	 * @throws IOException 
	 * @throws MalformedURLException 
	 * @throws InterruptedException 
	 */
	public static void main(String[] args) throws MalformedURLException, IOException,
			InterruptedException {
		final Random random = new Random();
		final Scanner scanner = new Scanner(new InputStreamReader(new URL(
				"http://map.e-map.co.jp/standard/11034020/ssmtop.htm").openStream(), "EUC-JP"));
		while (scanner.hasNextLine()) {
			final String line = scanner.nextLine();
			final Pattern pattern = Pattern
					.compile("<a href=\"(ssactl.htm\\?ENC=[^<> ]+)\".+><img src=\".+\".+alt=\"([^<>\"]+)\".+></a>");
			final Matcher matcher = pattern.matcher(line);
			if (matcher.find()) {
				//				System.out.println("found: " + matcher.group(1) + "->" + matcher.group(2));
				Thread.sleep(random.nextInt(5000));
				final Scanner scanner2 = new Scanner(new InputStreamReader(new URL(
						"http://map.e-map.co.jp/standard/11034020/" + matcher.group(1))
						.openStream(), "EUC-JP"));
				String prefecture = matcher.group(2);
				//System.out.println("DEBUG: prefecture = " + prefecture);
				while (scanner2.hasNextLine()) {
					final String line2 = scanner2.nextLine();
					final Pattern pattern2 = Pattern
							.compile("<IMG SRC=\"img/ken/[0-9]+.gif\" WIDTH=\"[0-9]+\" ALT=\"([^> ]+) +\">");
					final Matcher matcher2 = pattern2.matcher(line2);
					if (matcher2.find()) {
						prefecture = matcher2.group(1);
						//				System.out.println("DEBUG: prefecture = " + prefecture);
					}
					for (final String string : line2.split("</A>")) {
						final Pattern pattern3 = Pattern
								.compile("<A HREF=(ssactl.htm\\?ENC=.+)\">(.+)");
						final Matcher matcher3 = pattern3.matcher(string);
						String city = null;
						if (matcher3.find()) {
							//					System.out.println("DEBUG: getting " + matcher2.group(1) + "->"
							//							+ matcher2.group(2));
							city = matcher3.group(2);
							Thread.sleep(random.nextInt(5000));
							final URL url = new URL("http://map.e-map.co.jp/standard/11034020/"
									+ matcher3.group(1));
							get(prefecture, city, url);
						}
					}
				}
			}
		}
	}

	/**
	 * 三井住友銀行の住所一覧から住所を抽出します。
	 * @param prefecture 都道府県名
	 * @param city 市区町村名
	 * @param url URL
	 * @throws UnsupportedEncodingException
	 * @throws IOException
	 */
	private static void get(String prefecture, String city, final URL url)
			throws UnsupportedEncodingException, IOException {
		final Scanner scanner3 = new Scanner(new InputStreamReader(url.openStream(), "EUC-JP"));
		String caption = null;
		String address = null;
		boolean isSecond = false;
		while (scanner3.hasNextLine()) {
			final String line3 = scanner3.nextLine();
			final Pattern pattern4 = Pattern.compile("<a href=\"ssactl.htm\\?ENC=.+\">(.+)</a>");
			final Matcher matcher4 = pattern4.matcher(line3);
			if (matcher4.find()) {
				//System.out.println("DEBUG: " + matcher3.group(1));
				caption = matcher4.group(1);
			}
			final Pattern pattern5 = Pattern.compile("<span class=\"t10\">([^<>]+)</span></td>");
			final Matcher matcher5 = pattern5.matcher(line3);
			if (matcher5.find()) {
				//System.out.println("DEBUG: " + matcher4.group(1));
				address = matcher5.group(1);
				if (prefecture != null && city != null && caption != null && address != null) {
					System.out.println(prefecture + "," + city + "," + address + "," + caption);
				}
			}
			final Pattern pattern6 = Pattern
					.compile("<a href=\"(ssactl.htm\\?.+)\"><span class=\"t12\">次の20件</span></a>");
			final Matcher matcher6 = pattern6.matcher(line3);
			if (matcher6.find()) {
				if (isSecond) {
					get(prefecture, city, new URL("http://map.e-map.co.jp/standard/11034020/" + matcher6.group(1)));
				} else {
					isSecond = true;
				}
			}
		}
	}
}
