package shop;

import isj.ISJUtil;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;

import map.MapPanel;

/**
 * コンビニのホームページを解析して取得するクラスです。
 * @since 4.07
 * @author Kumano Tatsuo
 * 2006/07/21
 */
public class Convenience {
	/**
	 * キャッシュを保存するディレクトリ
	 */
	private static final String CACHE_DIR = ".map" + File.separator + "shops";

	/**
	 * キャッシュファイル名の接尾語
	 */
	private static final String SUFFIX = ".csv";

	/**
	 * @param cityID 市区町村コード
	 * @param cityLabel 市区町村名
	 * @param prefectureLabel 都道府県名
	 * @param isj 街区レベル位置参照情報
	 * @param panel 地図を描画するパネル
	 * @return コンビニの座標と表記の対応表
	 * @throws IOException 
	 */
	public Map<Point2D, String> getConvenience(final String cityID, final String cityLabel,
			final String prefectureLabel, final Map<String, Point2D> isj, final MapPanel panel) throws IOException {
		final Map<Point2D, String> ret = new LinkedHashMap<Point2D, String>();
		final Map<String, Point2D> tempIsj = new HashMap<String, Point2D>();
		for (final Map.Entry<String, Point2D> entry4 : isj.entrySet()) {
			tempIsj.put(entry4.getKey().replaceAll(",", ""), entry4.getValue());
		}

		for (ConvenienceParser parser : new ConvenienceParser[] { new Lawson(), new Famima(), new Sunkus(), new AmPm(),
				new Daiso(), new Doutor(), new Tsutaya(), new BookOff(), new Shop99() }) {
			final String url = parser.getURL(cityID, cityLabel, prefectureLabel);
			panel.addMessage(url + "をダウンロードしています。");
			if (!new File(CACHE_DIR).exists()) {
				new File(CACHE_DIR).mkdirs();
			}
			final String cacheFile = CACHE_DIR + File.separator + parser.getPrefix() + cityID + SUFFIX;
			if (!new File(cacheFile).exists()) {
				final PrintWriter out = new PrintWriter(new File(cacheFile), "SJIS");
				ISJUtil.parseAddresses(parser.getAddresses(url), out, tempIsj);
				out.close();
			}
			final Scanner scanner = new Scanner(new InputStreamReader(new FileInputStream(new File(cacheFile)), "SJIS"));
			while (scanner.hasNextLine()) {
				final String line = scanner.nextLine();
				final String[] items = line.split(",");
				if (items.length == 4) {
					final double x = Double.parseDouble(items[2]);
					final double y = Double.parseDouble(items[3]);
					ret.put(new Point2D.Double(x, y), parser.getLabel(items[1]));
				} else {
					System.out.printf("Convenience: %sのデータ形式が不正です：%s\n", cacheFile, line);
				}
			}
			scanner.close();
			panel.removeMessage();
		}
		return ret;
	}
}
