package shop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 三菱東京UFJ銀行の住所を取得するプログラムです。
 * @author Kumano Tatsuo
 * 2005/12/04
 * @since 3.16
 */
public class UFJ implements AddressParser {
	/**
	 * 最初のURL
	 */
	private static final String URL1 = "http://www.mapion.co.jp/c/f?uc=21&pg=3&bool=admi2code*benefit1&grp=bk_mufg&ob=u&oi=key6%252Cedit5&admi2=";

	/**
	 * 次のURL
	 */
	private static final String URL2 = "&benefit1=";

	/**
	 * 最後のURL
	 */
	private static final String URL3 = "&=%B8%A1%A1%A1%BA%F7";

	/**
	 * エンコーディング
	 */
	private static final String ENCODING = "SJIS";

	/**
	 * キャッシュファイル名の接頭語
	 */
	private static final String PREFIX = "ufj_";

	/**
	 * 都道府県名
	 */
	private String prefectureLabel = null;

	/**
	 * @since 4.10
	 */
	public Map<String, String> getAddresses(String url) throws IOException {
		final Map<String, String> ret = new LinkedHashMap<String, String>();
		try {
			final Scanner scanner = new Scanner(new InputStreamReader(new URL(url).openStream(), ENCODING));
			String caption = null;
			final Pattern pattern = Pattern
					.compile("<a href=\"/c/f\\?uc=[0-9]+&ino=[A-Z0-9]+&pg=[0-9]+&grp=bk_mufg\">([^<>]+)</a>");
			final Pattern pattern2 = Pattern
					.compile("<td bgcolor=\"#[a-z]+\" width=\"[0-9]+\"><font class=\"[a-z]+\">([^<>]+)</font></td>");
			while (scanner.hasNextLine()) {
				final String line = scanner.nextLine();
				final Matcher matcher = pattern.matcher(line);
				if (matcher.find()) {
					caption = matcher.group(1);
				}
				final Matcher matcher2 = pattern2.matcher(line);
				if (matcher2.find()) {
					if (caption != null) {
						if (!caption.startsWith("ATM")) {
							if (this.prefectureLabel == null) {
								System.out.println("UFJ: 都道府県名がnullです。" + url);
							} else {
								ret.put(this.prefectureLabel + matcher2.group(1), caption);
							}
						}
					}
				}
			}
			scanner.close();
		} catch (FileNotFoundException e) {
		}
		return ret;
	}

	/**
	 * @since 4.10
	 */
	public String getEncoding() {
		return ENCODING;
	}

	/**
	 * @since 4.10
	 */
	public String getLabel(String shopName) {
		return "MUFJ";
	}

	/**
	 * @since 4.10
	 */
	public String getPrefix() {
		return PREFIX;
	}

	/**
	 * @since 4.10
	 */
	public String getURL(String cityID, String cityLabel, String prefectureLabel) throws UnsupportedEncodingException {
		this.prefectureLabel = prefectureLabel;
		return URL1 + cityID.substring(0, 2) + URL2 + URLEncoder.encode(cityLabel, "EUC-JP") + URL3;
	}
}
