$(document).ready(function()
{
    $(document).on('click', 'td.child .addItem', function()
    {
        var child = $(this).parents('table').data('child');    
        $(this).closest('tr').after($('.table-'+ child +' tbody').html());
        $(this).closest('tr').next().find('.chosen').next('.chosen-container').remove();
        $(this).closest('tr').next().find('.chosen').chosen();
        $(this).closest('tr').next().find('.form-date, .form-datetime').datetimepicker(
        {
            language:  config.clientLang,
            weekStart: 1,
            todayBtn:  1,
            autoclose: 1,
            todayHighlight: 1,
            startView: 2,
            minView: 2,
            forceParse: 0,
            format: 'yyyy-mm-dd'
        });
    });

    $(document).on('click', 'td.child .delItem', function()
    {
        if($(this).parents('.table-child').find('tr').size() > 1)
        {
            $(this).closest('tr').remove();
        }
        else
        {
            $(this).closest('tr').find('input,select,textarea').val('');
        }
    })

    $('.reloadPage').click(function()
    {
        url = $(this).attr('href');

        $.getJSON(url, function(response)
        {
            if(response.message)
            {
                bootbox.alert(response.message, function()
                {
                    if(response.locate) 
                    {
                        location.href = response.locate;
                        return false;
                    }
                    location.reload();
                });
            }
            else
            {
                if(response.locate) 
                {
                    location.href = response.locate;
                    return false;
                }
                location.reload();
            }
        });
        return false;
    });

    $('#linkType').change(function()
    {
        var linkType = $(this).val();
        if(!linkType) return false;

        $('#linkTypeBox').modal('hide', 'fit');

        loadUnlinkData(linkType, 'browse', $(this).find('option:selected').text());
    });

    $('.unlink').click(function()
    {
        var url     = $(this).attr('href');
        var confirm = $(this).data('confirm');

        bootbox.confirm(confirm, function(result)
        {
            if(result)
            {
                $.getJSON(url, function(response)
                {
                    if(response.result == 'success')
                    {
                        location.reload();
                    }
                    else
                    {
                        bootbox.alert(response.message);
                    }
                })
            }
        })

        return false;
    });

    $('.prevP').each(function()
    {
        loadPrevData($(this), 0, 'p');
    });

    $('.prevTR').each(function()
    {
        loadPrevData($(this), 0);
    });

    $('a[href=#' + linkType + ']').click();
    $.setAjaxForm('.form-ajax');

    if(viewMode == 'bysearch') loadUnlinkData(linkType, 'bysearch');

    fixMainAction();
})

/**
 * Load unlink data.
 *
 * @param  string linkType
 * @param  string mode
 * @param  string tabTitle
 * @access public
 * @return void
 */
function loadUnlinkData(linkType, mode, tabTitle)
{
    tabTitle = typeof tabTitle === 'undefined' ? '' : tabTitle;

    var pane    = $('#' + linkType).length == 1 ? linkType : 'common';
    var $navTab = $('#tabsNav .nav-tabs a[href=#' + pane + ']').parent();

    if($navTab.hasClass('hidden'))  $navTab.removeClass('hidden');
    if(!$navTab.hasClass('active')) $navTab.find('a').click();
    if(tabTitle) $navTab.find('a').html(tabTitle);

    $('#querybox').remove();

    var link = loadLink.replace('LINKTYPE', linkType).replace('MODE', mode);
    $.get(link, function(data)
    {
        $('#' + pane).html(data);
        $('#' + pane).find('[data-ride=table]').table();
        $('#' + pane).removeClass('without-search');
        initSearch();
    });
}

/**
 * Fix main action.
 *
 * @access public
 * @return void
 */
function fixMainAction()
{
    var wHeight = $(window).height();
    var fTop    = $('.tab-content .tab-pane:first .main-actions').offset().top;
    var fHeight = $('.tab-content .tab-pane:first .main-actions').outerHeight();
    if(fTop + fHeight >= wHeight)
    {
        $('body').addClass('main-actions-fixed');
        $('.main-actions').addClass('col-9');
    }
}

/**
 * Ajax get search form.
 *
 * @param  string   $queryBox
 * @param  callback $callback
 * @access public
 * @return void
 */
function ajaxGetSearchForm($queryBox, callback)
{
    if(!$queryBox) $queryBox = $('#querybox');
    if($queryBox.html() == '')
    {
        $.get(createLink('search', 'buildForm'), function(data)
        {
            $queryBox.html(data);
            callback && callback();
        });
    }
}

/**
 * Init search form.
 *
 * @access public
 * @return void
 */
function initSearch()
{
    $searchTab = $('#bysearchTab');
    if($searchTab.data('initSearch')) return;

    if(!$searchTab.closest('#menu').length)
    {
        $('#menu>.container>.nav:first').append($searchTab);
    }

    var $queryBox = $('#querybox');
    if(!$queryBox.length)
    {
        $queryBox = $("<div id='querybox' class='hidden'/>").insertAfter($('#menu'));
    }

    if(mode == 'bysearch')
    {
        $('#menu > ul > li.active').removeClass('active');
        ajaxGetSearchForm($queryBox);
        $searchTab.addClass('active').find('a').attr('href', '#bysearch');
        $queryBox.removeClass('hidden');
    }

    $searchTab.on('click', function()
    {
        var isSearchTabActive = $searchTab.hasClass('active');
        if(isSearchTabActive)
        {
            var $oldTab = $searchTab.data('oldTab');
            if($oldTab)
            {
                $oldTab.addClass('active');
            }
            else
            {
                $searchTab.addClass('selected');
            }
        }
        else
        {
            $(window).scrollTop(0);
            $searchTab.data('oldTab', $('#menu > ul > li.active').removeClass('active'));
            ajaxGetSearchForm($queryBox, function()
            {
                if(!$queryBox.hasClass('hidden')) $queryBox.trigger('querybox.toggle', true);
            });
        }
        $searchTab.toggleClass('active', !isSearchTabActive);
        $queryBox.toggleClass('hidden', isSearchTabActive).trigger('querybox.toggle', !isSearchTabActive);
    });

    $searchTab.data('initSearch', true);
}
