// scan_udpport.c
// $Id: scan_udpport.c,v 1.1.1.1 2007/09/19 05:49:54 sendan Exp $
// masashi shimakura


#include<stdio.h>
#include<string.h>
#include<netdb.h>
#include<unistd.h>
#include<sys/socket.h>
#include<netinet/in_systm.h>
#include<netinet/in.h>
#include<netinet/ip.h>
#include<netinet/ip_icmp.h>
#include<sys/stat.h>
#include<arpa/inet.h>

#include "sitar_scan.h"
#include "sitar_com.h"
#include "almemsys.h"
#include "jpreturn.h"


/* 1-> port No' 2-> Ipsddr 3-> return data,, return status code 0=open or=close
int scan_udp_connect(int, char *, char *, int);
*/


/*----------------- SCAN UDP CONNECT --------------------*/
char * scan_udp_connect(int port, char * ip_addr, char * backdata, int timeout, int * stat)
{
char ipa2[IP_LEN];
char * ip_addr2 = ipa2;
char buff[1024];
int send_sk, recv_sk, select_stat;
unsigned long resoip;
struct icmp *icmp;
struct sockaddr_in send_addr;
struct timeval tv;
fd_set select_fd;

send_addr.sin_family = AF_INET;

backdata = resolvename(backdata, ip_addr, timeout, &resoip);
send_addr.sin_addr.s_addr = resoip;

if(0 == (int)send_addr.sin_addr.s_addr || resoip == (int)NULL){
   backdata=safe_sprintf(backdata,BUF_MAX,"%s %s %d\n",
    SOCK_2, ip_addr, (int)send_addr.sin_addr.s_addr);
   #ifdef UDP_BUG
   printf("UDP: scan_udp_connect(1): START %s\n", backdata);
   #endif
   * stat = -1;
   return backdata;
   }

ip_addr2 = inet_ntoa(send_addr.sin_addr);

#ifdef UDP_BUG
printf("UDP: scan_udp_connect(2): UDP host<%s> ip<%s>\n",ip_addr2, ip_addr);
#endif

// UDP ソケットを作る
if((send_sk = socket(AF_INET, SOCK_DGRAM, 0)) < 0){
   backdata=safe_sprintf(backdata,BUF_MAX,
    "IP=%s Port=%d UDP %s", ip_addr, port, SOCK_1);
   #ifdef UDP_BUG
   printf("UDP: scan_udp_connect(3): SEND UDP PACKET %s\n", backdata);
   #endif
   * stat = -10;
   return backdata;
   }

// RAWソケットを作る
if((recv_sk = socket(AF_INET, SOCK_RAW, IPPROTO_ICMP)) < 0){
   backdata=safe_sprintf(backdata,BUF_MAX,
    "IP=%s Port=%d ICMP %s", ip_addr, port, SOCK_1);
   * stat = -10;
   #ifdef UDP_BUG
   printf("UDP: scan_udp_connect(4): SEND ROW PACKET %s\n", backdata);
   #endif
   return backdata;
   }

// UDPソケットの送信
send_addr.sin_port = htons(port);
sendto(send_sk, NULL, 0, 0, (struct sockaddr *)(long int)&send_addr, sizeof(send_addr));

tv.tv_sec =timeout;
tv.tv_usec =0;

while(1){
   FD_ZERO(&select_fd);
   FD_SET(recv_sk, &select_fd);

   // selectでタイムアウト
   if((select_stat = select(recv_sk + 1, &select_fd, NULL, NULL, &tv)) > 0){
      struct ip *ip;
      int hlen;
      int ports;
      // RAWソケットの受け取り
      if(recvfrom(recv_sk, buff, 1024, 0, NULL, NULL) != 56){
         #ifdef UDP_BUG
         printf("UDP: scan_udp_connect(5): ");
         printf("(%d %d)サイズ違いのパケットを受け取りました、始めから\n", recv_sk, select_stat);
         #endif
         continue;
         }
      // 受信パケットの評価
      ip = (struct ip *)(long int)buff;
      hlen = ip->ip_hl << 2;
      icmp = (struct icmp*)(buff + hlen);
      ports = ntohs(*(u_short *)(buff + 20 + 8 + 20 + 2));
      if((ip->ip_src.s_addr != send_addr.sin_addr.s_addr)
         || (icmp->icmp_type != ICMP_UNREACH)
         || (icmp->icmp_code != ICMP_UNREACH_PORT)
         || (ports != port)){
         #ifdef UDP_BUG
         printf("UDP: scan_udp_connect(6): ");
         printf("(%d %d)ポート不達でないICMPパケットを受け取ってます、始めから\n", recv_sk, select_stat);
         #endif
         continue;
         }
      else{
         backdata=safe_sprintf(backdata,BUF_MAX,
           "IP=%s Port=%d UDP %s", ip_addr, port, SOCK_7);
         #ifdef UDP_BUG
         printf("UDP: scan_udp_connect(7): ");
         printf("(%d %d)ポート不達ICMPパケットを受け取ってます、エラー\n", recv_sk, select_stat);
         #endif
         close(send_sk);
         close(recv_sk);
         * stat = 1;
         return backdata;
         }
      }

   else{
      struct servent *se;
      se = getservbyport(htons(port), "udp");
      backdata=safe_sprintf(backdata,BUF_MAX,
       "IP=%s Port=%d %s UDP %s",
         ip_addr, port, (se==NULL)?"unknown":se->s_name, SOCK_3);
      #ifdef UDP_BUG
      printf("UDP: scan_udp_connect(8): RECV %s", backdata);
      printf("(%d %d) タイムアウトしました\n", recv_sk, select_stat);
      #endif
      close(send_sk);
      close(recv_sk);
      * stat = 0;
      return backdata;
      }

   #ifdef UDP_BUG
   printf("UDP: scan_udp_connect(9): RECV %s", backdata);
   printf("(%d %d)BREAKします。\n", recv_sk, select_stat);
   #endif
   break;
   }

backdata=safe_sprintf(backdata,BUF_MAX,
 "IP=%s Port=%d UDP %s", ip_addr, port, SOCK_5);
#ifdef UDP_BUG
printf("UDP: scan_udp_connect(10): END %s", backdata);
printf("(%d %d)戻りパケットをうけとれませんでした。エラー\n", recv_sk, select_stat);
#endif


close(send_sk);
close(recv_sk);
* stat = 1;
return backdata;
}






