/* masashi shimakrau  */
#include<stdio.h>
#include<stdlib.h>
#include<string.h>

#include"zither_lint.h"
#include"almemsys.h"

#include "/usr/local/pgsql/include/libpq-fe.h"

global_data_t gd;
PGconn * conn;
PGresult * res;


int main(void)
{
int ret, len, del, no, stat;
FILE * fp;
char * swap;

len = 0;
del = 0;
stat = 0;

swap = (char *)calloc(BUF_DEFLEN, sizeof(char));

malloc_set();

printf("/*------------------------------------------*/\n");
printf("zither_lint はzither用データベースに手書きの\n");
printf("監視リストファイルをDBに反映するプログラムです。\n");
printf("リストファイルのパスを指定してください \n");
printf("/*------------------------------------------*/\n");
printf("\n");
printf("<注意>ファイルの日本語はあらかじめEUC-JPに変換してください。\n");
printf("      このプログラムは構文チェックしか行いません。 \n");
printf("      このプログラムはブロック行(SET)の反映は出来ません。 \n");
printf("      ブロックは予め作ってください。 \n");
printf("/*------------------------------------------*/\n");
printf("\n");
printf("<例>/tmp/test.list<Enter>\n");

if((gd.filename = fgets(gd.filename, BUF_LEN, stdin))!=NULL){
   swap_mem(gd.filename, '\n', (char)0x00, (int)strlen(gd.filename));
   }
else{
   printf("ファイル名を入力してね\n");
   exit(1);
   }

printf("ファイル名 <%s> を開いています \n", gd.filename);
if((fp = fopen(gd.filename, "r"))==NULL){
   printf("ファイルは開けません、このまま終了します。\n");
   exit(1);
   }
else{
   printf("ファイルが開けました \n");
   printf("\n");

   ret = bufinfile(fp, gd.lendata, &len);

   for(no = 0; no < len; no++){ 
      if(0 > portcheck(0, gd.lendata[no][0])){
          printf("%d 行目の %d 番めのデータ <%s> に間違いがあります\n",(no + 1),(0 + 1),gd.lendata[no][0]);
          exit(1);
          }
      if(0 > statcheck(gd.lendata[no][1])){
          printf("%d 行目の %d 番めのデータ <%s> に間違いがあります\n",(no + 1),(1 + 1),gd.lendata[no][1]);
          exit(1);
          }
      if(0 == self_memcmp(gd.lendata[no][0], "SNMP")){
          if(0 > protocheck(1, gd.lendata[no][2])){
              printf("%d 行目の %d 番めのデータ <%s> に間違いがあります\n",(no + 1),(2 + 1),gd.lendata[no][2]);
              exit(1);
              }
          }
      else{
          if(0 > protocheck(0, gd.lendata[no][2])){
              printf("%d 行目の %d 番めのデータ <%s> に間違いがあります\n",(no + 1),(2 + 1),gd.lendata[no][2]);
              exit(1);
              }
          }
      if(0 > startcheck(1, gd.lendata[no][8])){
          printf("%d 行目の %d 番めのデータ <%s> に間違いがあります\n",(no + 1),(8 + 1),gd.lendata[no][8]);
          exit(1);
          }

      if(0 == self_memcmp(gd.lendata[no][0], "SNMP")){
          if(0 > protocheck(1, gd.lendata[no][5])){
              printf("%d 行目の %d 番めのデータ <%s> に間違いがあります\n",(no + 1),(5 + 1),gd.lendata[no][5]);
              exit(1);
              }
          }
      else{
         if(0 > startcheck(1, gd.lendata[no][5])){
             printf("%d 行目の %d 番めのデータ <%s> に間違いがあります\n",(no + 1),(5 + 1),gd.lendata[no][5]);
             exit(1);
             }
          }

      if(0 > startcheck(1, gd.lendata[no][6])){
          printf("%d 行目の %d 番めのデータ <%s> に間違いがあります\n",(no + 1),(6 + 1),gd.lendata[no][6]);
          exit(1);
          }
      }

   printf("ファイルを閉じます \n");
   printf("\n");
   fclose(fp);
   }

printf("/*------------------------------------------*/\n");
printf("ファイルの読み込みは正常に終わりました \n");
printf("\n");
printf("データベースの内容との不整合を見つけます \n");
printf("\n");
printf("postgreSQLの動作するホスト名を入力してください \n");
printf("/*------------------------------------------*/\n");
printf("<例>127.0.0.1<Enter>\n");

if((gd.pg_host = fgets(gd.pg_host, BUF_LEN, stdin))!=NULL){
   swap_mem(gd.pg_host, '\n', (char)0x00, (int)strlen(gd.pg_host));
   }
else{
   printf("ほすと名を入力してね\n");
   exit(1);
   }

gd.pg_hostdata = safe_sprintf(gd.pg_hostdata, BUF_MAX,
   "hostaddr='%s' port='5432' dbname='zither' connect_timeout='8'", gd.pg_host);

printf("hostdata=: <%s>\n", gd.pg_hostdata);

if(-1 == (pqconnect(gd.pg_hostdata))){
   printf("データベースに接続出来ませんでした \n");
   exit(1);
   }
printf("データベースに接続出来ました \n");
printf("\n");
printf("ブロック名が登録済みかを確認していきます。 \n");
printf("\n");


for(no = 0; no <= len; no++){ 
   swap = safe_sprintf(swap, BUF_MAX,"select * from userblock where bname='%s';", gd.lendata[no][12]);
   swap = pqexec_select(swap, &stat);
   if(1 > stat){
      printf("%d 行目 : 検索内容<%s>が引けません\n", (no + 1), gd.lendata[no][12]);
      exit(1);
      }
   gd.lendata[no][13] = safe_memcpy(gd.lendata[no][13], swap, BUF_MAX);
   printf("%d 行目 : 監視ブロック名<%s> 監視クライアント名<%s>\n", (no + 1), gd.lendata[no][12], gd.lendata[no][13]);
   }

printf("\n");
printf("監視データの整合性は確認出来ました、監視データを入力していきます \n");
printf("/*------------------------------------------*/\n");
printf("このままデータを反映してかまわない場合は<enter>を押してください。\n");
getchar();
printf("\n");

for(no = 0; no <= len; no++){ 
   swap = safe_sprintf(swap, BUF_MAX, "%s('OFF', '%s', '%s', %s, '%s', '%s', '%s', '%s', %s, '%s', %s, '%s', '%s', 'NOT', '%s');",
     "INSERT INTO monitor VALUES ",
     gd.lendata[no][13],
     gd.lendata[no][0],
     gd.lendata[no][1],
     gd.lendata[no][2],
     gd.lendata[no][3],
     gd.lendata[no][4],
     gd.lendata[no][5],
     gd.lendata[no][6],
     gd.lendata[no][7],
     gd.lendata[no][8],
     gd.lendata[no][9],
     gd.lendata[no][10],
     gd.lendata[no][12]);


   printf("<%d> この監視項目を入れます : %s\n", no, swap);
   printf("\n");

   if(0 > pqexec_datain(swap)){
      printf("入力に失敗してしまいました。w 苦労するでしょうが、気長にやりましょうよ。\n");
      exit(1);
      }

   printf("監視項目の入力に成功しました。WEB等から確認してください。 \n");
   printf("\n");

   }

printf("\n");
printf("/*------------------------------------------------*/\n");
printf("おめでとう！　よくここまで我慢できましたね。\n");
printf("データベースへの反映は最後までウマクいったようです！！ \n");
printf("反映された監視はデフォルトでOFF状態です。 \n");
printf("アポロンから設定を変更してください。\n");
printf("/*------------------------------------------------*/\n");
printf("\n");
printf("\n");


free(swap);
malloc_free();

return 0;
}



