// fileset.c
// $Id: fileset.c,v 1.3 2007/10/18 06:03:21 sendan Exp $
// masashi shimakura

#include<stdio.h>
#include<unistd.h>
#include<netinet/in.h>
#include<string.h>
#include<stdlib.h>
#include<sys/stat.h>
#include<pthread.h>


#include"zither.h"
#include"almemsys.h"


extern global_data_t gd;


int file_check(char *);
int get_file(char *, char *, char);
int get_file2(char *, char, int, int);




/* ------------------ FILE SET 1.1.7 以上の為 ----------------- */
int file_sets2( private_data_t * pd, char delim, int sk, int interval)
{
int stat;
int inA = 1;
int count, cho;
// char * tmp;

char * chA = (char *)calloc(IP_LEN, sizeof(char));
char * chB = (char *)calloc(IP_LEN, sizeof(char));
char * chC = (char *)calloc(IP_LEN, sizeof(char));

chA = safe_memcpy(chA, pd->rec.data, BUF_MAX);
count = strlen(pd->rec.data);
cho = mem_count(pd->rec.data,':');

// printf("file_sets2(): %s\n", pd->rec.data);

// if( NULL != strchr(pd->rec.data,':') && 3 <= cho && (count - cho) > 3 && count > 7 && 1 != mem_count(pd->rec.data, '#')){
//    chB = safe_memcpy(chB, strtok_r(chA, ":", &tmp), BUF_MAX);

inA = file_check(pd->rec.data);
stat = 1;
switch(inA){
   case 1 : stat = get_file2(pd->file.bat_filename, (char)delim, sk, interval);
           break;  
   case 2 : stat = get_file2(pd->file.scan_filename, (char)delim, sk, interval);
           break;  
   case 3 : stat = get_file2(pd->file.conf_filename, (char)delim, sk, interval);
           break;  
   case 4 : stat = get_file2(pd->file.stat_filename, (char)delim, sk, interval);
           break;  
   default : stat = -1;  // 意外の場合はエラー
           printf("file_sets2(): ないファイルを指定してます\n");
           socket_send(sk, "500NG: file name check err.\n", interval);
           break;
   }

free(chA);
free(chB);
free(chC);

return(stat);
}







/* ------------------ FILE SET 1.1.3 以上の為 ----------------- */
int file_sets( private_data_t * pd, char delim )
{
static int stat;
int inA = 1;
int count, cho;
char * tmp;

char * chA = (char *)calloc(IP_LEN, sizeof(char));
char * chB = (char *)calloc(IP_LEN, sizeof(char));
char * chC = (char *)calloc(IP_LEN, sizeof(char));

chA = safe_memcpy(chA, pd->rec.data, BUF_MAX);
count = strlen(pd->rec.data);
cho = mem_count(pd->rec.data,':');

stat = -1;
if( NULL != strchr(pd->rec.data,':') && 3 <= cho && (count - cho) > 3 && count > 7
    && 1 != mem_count(pd->rec.data, '#')){
   chB = safe_memcpy(chB, strtok_r(chA, ":", &tmp), BUF_MAX);
   chC = safe_memcpy(chC, 1 + strchr(pd->rec.data, ':'), BUF_MAX);
   rm_crlf(chC, (int)strlen(chC));
   inA = file_check(chB);
   stat = 1;
   switch(inA){
      case 1 : stat = get_file(pd->file.bat_filename, chC, (char)delim);
              break;  
      case 2 : stat = get_file(pd->file.scan_filename, chC, (char)delim);
              break;  
      case 3 : stat = get_file(pd->file.conf_filename, chC, (char)delim);
              break;  
      case 4 : stat = get_file(pd->file.stat_filename, chC, (char)delim);
              break;  
      default : stat = -1;
              break;
      }
   }

free(chA);
free(chB);
free(chC);

return(stat);
}







/* ------------ get_file --------------- */
int get_file(char * filename, char * data, char delim)
{
static int ret;
struct stat stat_buf;
FILE * fp;
int fd;

ret = 0;
if(0 == stat(filename, &stat_buf)){
   fprintf(stderr,"It doesn't write it because there is a file. %s\n", filename);
   ret = -1;
   }
else {
   if((fp = fopen(filename, "w+"))!=NULL){
      fd = fileno(fp);
      swap_mem(data, (char)delim, '\n', (int)strlen(data));
      fprintf(fp,"%s",data);
      fclose(fp);
      }
   else{
      fprintf(stderr,"new file Not open %s\n", filename);
      }
   fprintf(stderr,"The client wrote it because there was no file. %s\n", filename);
   ret = 1;
   }

return(ret);
}








/* ------------------ FILE SET 1.1.7 以上の為 ----------------- */
int get_file2(char * filename, char delim, int sk, int interval)
{
int ret;
// int fd;
struct stat stat_buf;
// FILE * fp;
char * rec;

rec = (char *)calloc(IP_LEN, sizeof(char));
ret = 0;

if(0 == stat(filename, &stat_buf)){
   fprintf(stderr,"It doesn't write it because there is a file. %s\n", filename);
   socket_send(sk, "500NG: not file status.\n", interval);
   ret = 0;
   }
else {
//   if((fp = fopen(filename, "w+"))!=NULL){
//      fd = fileno(fp);

      socket_send(sk, "200OK\n", interval);

//    swap_mem(data, (char)delim, '\n', (int)strlen(data));
//    fprintf(fp,"%s",data);


      rec = alget_read(filename, rec, sk, interval, &ret, (char)delim, FILE_LEN, 1);


//      fclose(fp);
//      }
//   else{
//      fprintf(stderr,"new file Not open %s\n", filename);
//      socket_send(sk, "500NG: not file open.\n", interval);
//      ret = -1;
//      }
   fprintf(stderr,"The client wrote it because there was no file. %s\n", filename);
   ret = 0;
   }

free(rec);

return(ret);
}








/* ------------------ PATH CHECK ----------------- */
int file_check(char *chA)
{
static int bu;
char ch[6][IP_LEN];
int count = 0;
char * non="NON";
char * comand="COMAND";
char * port="PORT";
char * conf="CONF";
char * stat="STAT";

self_memcpy(ch[0], non, IP_LEN);
self_memcpy(ch[1], comand, IP_LEN);
self_memcpy(ch[2], port, IP_LEN);
self_memcpy(ch[3], conf, IP_LEN);
self_memcpy(ch[4], stat, IP_LEN);

bu = 0;
if(IP_LEN > strlen(chA)){
   for(count=0; count < 5; count++){
      if(0 == memcmp(chA, ch[count], (int)strlen(ch[count])+1)){
         bu=count;
         }
      }
   }
else{
   fprintf(stderr,"big size mess err. %s\n", chA);
   }
return(bu);
}




