
#include<stdio.h>
#include<unistd.h>
#include<sys/wait.h>
#include<netinet/in.h>
#include<string.h>
#include<stdlib.h>
#include<signal.h>
#include<pthread.h>

#include"sitar.h"
#include"sitar_com.h"
#include<almemsys/almemsys.h>
#include"jpreturn.h"
#include<file_comp/file_comp.h>

extern global_data_t gd;

extern pthread_mutex_t fd_mutex;
extern pthread_mutex_t break_mutex;
extern char * sitarpid;



// sitarへのアクションを指定するファイル ***.statファイルをとってくる関数
int get_statfile(char * senddata)
{
FILE * fp;
int pid, stat, interval;

char * rec = (char *)calloc(BUF_LEN, sizeof(char));
char * recs = (char *)calloc(BUF_LEN, sizeof(char));
char * recdata = (char *)calloc(BUF_LEN, sizeof(char));
char * intr = (char *)calloc(BUF_LEN, sizeof(char));

interval = (gd.bf.life_int + gd.bf.life_los + INT_PLUS);

// intr = safe_sprintf(intr, BUF_MAX,"%s :: COM: UNDIF DATA: %s\n", gd.bf.c_name, senddata);
intr = safe_sprintf(intr, BUF_MAX,"%s :: COM: SLGET DATA: %s\n", gd.bf.c_name, senddata);

//pthread_mutex_lock(&fd_mutex);
safe_pthread_mutex_lock(&fd_mutex);
if((stat = socket_send(gd.ip.sk, intr, interval)) > 0){
   rec = select_fdcat(gd.ip.sk, rec, &stat, BUF_MAX, interval);
   }
if(stat < 0){
   safe_exit("get_statfile(1): socket err exit \n");
   }
pthread_mutex_unlock(&fd_mutex);

// swap_mem(rec, (char)0x05, (char)0x00);
swap_mem(rec, (char)0x05, ' ');

#ifdef STATFILE_DEBUG
printf("STATFILE: get_statfile(): %s\n", rec);
#endif

if(0 != (memcmp(rec, "500 NG", 6))){

   if(gd.bf.stop_count > 0){
      if(0 == (memcmp("KILL", rec, 4))){
         if((fp = fopen(sitarpid, "r"))!=NULL){
             recs = safe_fpcat(fp, recs, &stat, BUF_LEN);
             if(stat != -1){
                #ifdef STATFILE_DEBUG
                printf("STATFILE: get_statfile(): startctlpid->%s\n",recs);
                #endif
                pid = strtol(recs, (char **)NULL, 10);
                if(! kill(pid, SIGKILL)){
                   fprintf(stderr,"get_statfile(): killd 'sitarctl'.. PID = %d\n", pid);
                   } 
                else{
                   fprintf(stderr,"get_statfile(): not killd 'sitarctl'.. PID = %d\n", pid);
                   } 
                fclose(fp);
                }
             else{
                fprintf(stderr,"get_statfile(): It is not possible to read normally. <%s>\n", sitarpid);
                safe_exit("2 get_statfile(): exit\n"); // It ends. 
                }
            }
         else{
            fprintf(stderr,"get_statfile(): pid file not open. %s\n", sitarpid);
            safe_exit("3 get_statfile(): exit\n"); // It ends. 
            }
         safe_exit("get_statfile(): Cease and desist order \n"); // It ends. 
         #ifdef FREE_BUG
         printf("FREE: get_statfile(): statfile_free(1): \n");
         #endif

         free(rec);
         free(recs);
         free(recdata);
         free(intr);
         return stat;
         }

      if(0 == (memcmp("RESTART", rec, 7))){
         fprintf(stderr,"get_statfile(): Get RESTART stat. \n");
         safe_exit("get_statfile(): Reactivation instruction. \n"); // It ends. 
         #ifdef FREE_BUG
         printf("FREE: get_statfile(): statfile_free(2): \n");
         #endif
         free(rec);
         free(recs);
         free(recdata);
         free(intr);
         return stat;
         }
      if(0 == (memcmp("UPDATE", rec, 6))){
         fprintf(stderr,"get_statfile(): Get UPDATE stat. \n");
         rec = execom(gd.fi.update_com, rec, 30, 1);
         fprintf(stderr, "%s\n", rec);
         safe_exit("get_statfile(): reactivates for update. \n"); // It ends. 
         #ifdef FREE_BUG
         printf("FREE: get_statfile(): statfile_free(3): \n");
         #endif
         free(rec);
         free(recs);
         free(recdata);
         free(intr);
         return stat;
         }
      }

// pthread_mutex_lock(&break_mutex);
   safe_pthread_mutex_lock(&break_mutex);
   if(0 == (memcmp("STOP", rec, 4))){
      #ifdef STATFILE_DEBUG
      printf("STATFILE: get_statfile(): STAT %s\n", rec);
      #endif
      fprintf(stderr,"get_statfile(): Get STOP stat. \n");
      #ifdef FREE_BUG
      printf("FREE: get_statfile(): statfile_free(4): \n");
      #endif
      free(rec);
      free(recs);
      free(recdata);
      free(intr);
      gd.bf.break_count = 1;
      gd.bf.stop_count = 1;
      return stat;
      }
   if(0 == (memcmp("START", rec, 5))){
      #ifdef STATFILE_DEBUG
      printf("STATFILE: get_statfile():  ********** STAT %s ************ \n", rec);
      #endif
      fprintf(stderr,"get_statfile(): Get START stat. \n");
      #ifdef FREE_BUG
      printf("FREE: get_statfile(): statfile_free(5): \n");
      #endif
      free(rec);
      free(recs);
      free(recdata);
      free(intr);

      gd.bf.break_count = 0;
      gd.bf.stop_count = 1;
      return stat;
      }
   pthread_mutex_unlock(&break_mutex);

   }

else {
   fprintf(stderr,"get_statfile(): server side stat file not open.\n");

   intr = safe_sprintf(intr, BUF_MAX,
     "%s :: COM: UP DATA: STAT:%s\n", gd.bf.c_name, "START");

   if(1 < (int)strlen(rec)){
//    pthread_mutex_lock(&fd_mutex);
      safe_pthread_mutex_lock(&fd_mutex);
      if((stat = socket_send(gd.ip.sk, intr, interval)) > 0){
         recdata = select_fdcat(gd.ip.sk, recdata, &stat, BUF_MAX, interval); 
         }
      if(stat < 0){
         safe_exit("get_statfile(2): socket err exit \n");
         }
      pthread_mutex_unlock(&fd_mutex);
      }

   fprintf(stderr,"get_statfile(): %s\n", recdata);
   }

#ifdef FREE_BUG
printf("FREE: get_statfile(): statfile_free(6): \n");
#endif
free(rec);
free(recs);
free(recdata);
free(intr);

//pthread_mutex_lock(&break_mutex);
safe_pthread_mutex_lock(&break_mutex);
gd.bf.stop_count = 1;
pthread_mutex_unlock(&break_mutex);

return stat;
} 




