
/* SSL/TSL 関係のヘッダーファイル */
#include <openssl/crypto.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rand.h>

#include"sitar_scan.h"
#include<almemsys/almemsys.h>



// char *  verify_ssl(char * data, SSL *ssl, int * err);


char * verify_ssl(char * data, SSL *ssl, int * err)
{
long verify_result;

struct sslerror_t {
   long result_code;
   char *ssl_error;
   char *ssl_errordetail;
   };

struct sslerror_t error_table[]={
  {X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT,
     "unable to get issuer certificate. ",
     "the issuer certificate could not be found: this occurs if the"
     "issuer certificate of an untrusted certificate cannot be found."
     },
  {X509_V_ERR_UNABLE_TO_GET_CRL,
     "unable to get certificate CRL. ",
     "the CRL of a certificate could not be found. Unused."
     },
  {X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE,
     "unable to decrypt certificate's signature",
     "the certificate signature could not be decrypted. This means that"
     "the actual signature value could not be determined rather than it"
     "not matching the expected value, this is only meaningful for RSA keys"
     },
  {X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE,
     "unable to decrypt CRL's signature",
     "the CRL signature could not be decrypted: this means that the"
     "actual signature value could not be determined rather than it not"
     "matching the expected value. Unused."
     },
  {X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY,
     "unable to decode issuer public key",
     "the public key in the certificate SubjectPublicKeyInfo could not be read"
     },
  {X509_V_ERR_CERT_SIGNATURE_FAILURE,
     "certificate signature failure",
     "the signature of the certificate is invalid"
     },
  {X509_V_ERR_CRL_SIGNATURE_FAILURE,
     "CRL signature failure",
     "the signature of the certificate is invalid. Unused"
     },
  {X509_V_ERR_CERT_NOT_YET_VALID,
     "The expiration date of the certificate is a date of the future.",
     "It has not reached yet at the beginning date when the certificate becomes effective."
     "Isn't the time setting amusing?"
     },
  {X509_V_ERR_CERT_HAS_EXPIRED,
     "Slice of expiration date of certificate.",
     "It is done that the certificate is old.:"
     },
  {X509_V_ERR_CRL_NOT_YET_VALID,
     "CRL is not yet valid",
     "the CRL is not yet valid. Unused."
     },
  {X509_V_ERR_CRL_HAS_EXPIRED,
     "CRL has expired",
     "the CRL has expired. Unused."
     },
  {X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD,
     "format error in certificate's notBefore field",
     "the certificate notBefore field contains an invalid time"
     },
  {X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD,
     "format error in certificate's notAfter field",
     "the certificate notAfter field contains an invalid time."
     },
  {X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD,
     "format error in CRL's lastUpdate field",
     "the CRL lastUpdate field contains an invalid time. Unused."
     },
  {X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD,
     "format error in CRL's nextUpdate field",
     "the CRL nextUpdate field contains an invalid time. Unused.:" 
     },
  {X509_V_ERR_OUT_OF_MEM,
     "The memory is not worth.",
     "The memory was not able to be secured. This error should not occur."
     },
  {X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT,
     "self signed certificate",
     "the passed certificate is self signed and the same certificate"
     "cannot be found in the list of trusted certificates."
     },
  {X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN,
     "self signed certificate in certificate chain",
     "the certificate chain could be built up using the untrusted"
     "certificates but the root could not be found locally."
     },
  {X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY,
     "unable to get local issuer certificate",
     "the issuer certificate of a locally looked up certificate could not"
     "be found. This normally means the list of trusted certificates is"
     "not complete."
     },
  {X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE,
     "unable to verify the first certificate",
     "no signatures could be verified because the chain contains only one"
     "certificate and it is not self signed."
     },
  {X509_V_ERR_CERT_CHAIN_TOO_LONG,
     "certificate chain too long",
     "the certificate chain length is greater than the supplied maximum"
     "depth. Unused."
     },
  {X509_V_ERR_CERT_REVOKED,
     "certificate revoked",
     "the certificate has been revoked. Unused."
     },
  {X509_V_ERR_INVALID_CA,
     "invalid CA certificate",
     "a CA certificate is invalid. Either it is not a CA or its"
     "extensions are not consistent with the supplied purpose."
     },
  {X509_V_ERR_PATH_LENGTH_EXCEEDED,
     "path length constraint exceeded",
     "the basicConstraints pathlength parameter has been exceeded."
     },
  {X509_V_ERR_INVALID_PURPOSE,
     "unsupported certificate purpose",
     "the supplied certificate cannot be used for the specified purpose."
     },
  {X509_V_ERR_CERT_UNTRUSTED,
     "certificate not trusted",
     "the root CA is not marked as trusted for the specified purpose."
     },
  {X509_V_ERR_CERT_REJECTED,
     "The certificate was rejected.",
     "the root CA is marked to reject the specified purpose.:"  
     },
  {X509_V_ERR_SUBJECT_ISSUER_MISMATCH,
     "subject issuer mismatch",
     "the current candidate issuer certificate was rejected because its"
     "subject name did not match the issuer name of the current"
     "certificate. Only displayed when the -issuer_checks option is set."
     },
  {X509_V_ERR_AKID_SKID_MISMATCH,
     "authority and subject key identifier mismatch",
     "the current candidate issuer certificate was rejected because its"
     "subject key identifier was present and did not match the authority"
     "key identifier current certificate. Only displayed when the"
     "-issuer_checks option is set."
     },
  {X509_V_ERR_AKID_ISSUER_SERIAL_MISMATCH,
     "authority and issuer serial number mismatch",
     "the current candidate issuer certificate was rejected because its"
     "issuer name and serial number was present and did not match the"
     "authority key identifier of the current certificate. Only displayed"
     "when the -issuer_checks option is set."
     },
  {X509_V_ERR_KEYUSAGE_NO_CERTSIGN,
     "key usage does not include certificate signing",
     "the current candidate issuer certificate was rejected because its"
     "keyUsage extension does not permit certificate signing."
     },
  {X509_V_ERR_APPLICATION_VERIFICATION,
     "application verification failure",
     "an application specific error. Unused."
     }
  };

verify_result = SSL_get_verify_result(ssl);

if ( verify_result == X509_V_OK ){
   #ifdef SSL_BUG
   printf("SSL_BUG: verify_ssl(): 認証に成功しました。エラーはありません。\n");
   #endif
   }
else {
   int i;

   #ifdef SSL_BUG
   printf("SSL_BUG: verify_ssl(): 認証時にエラー発生。続行します。\n");
   #endif

   for ( i=0 ; i<sizeof(error_table)/sizeof(error_table[0]) ; i++ ){
      if ( error_table[i].result_code == verify_result ){
         * err = (int)verify_result;
         #ifdef SSL_BUG
         printf("SSL_BUG: verify_ssl(): SSL_get_verify_result の戻り値 = %d\n", * err);
         #endif
         data = safe_sprintf(data, BUF_MAX,"%s", error_table[i].ssl_error);
         break;
         }
      }
   }

return data;
}




