#!/usr/bin/env python

""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from common import *
from pgmlgraph import *
import getopt
import sys

def main():
	"""
	pgml2dot output a dot file

	usage: pgml2dot -f <pgml schema file> -o <dot file> [-h] 
	-h : this help
	-f : pgml file
	-o : dot file
	-s : simplify schema
	-i : id sequence
	-u : use postgreSql isa keyword when table inherits
	-g : dot graph options
	-t : table names 

	"""
	
	try:
		opts, args = getopt.getopt(sys.argv[1:], 'o:f:hsi:dug:t:')
	except getopt.error, msg:
		usage(msg)

	pgmlFilename=''
	dotFilename=''
	simplify=0
	idSequence = None
	debug = PYTHONDEBUG
	usePostgreSqlIsa = None
	dotOptions = None
	tableNames = None
	
	for o, a in opts:
		if o == '-f': pgmlFilename = a
		if o == '-o': dotFilename = a
		if o == '-h': usage(main.__doc__)
		if o == '-s': simplify = 1
		if o == '-i': idSequence = a
		if o == '-d': debug = 1
		if o == '-u': usePostgreSqlIsa = 1
		if o == '-g': dotOptions = a
		if o == '-t': tableNames = a		

	if not pgmlFilename: usage(main.__doc__,'error : missing database pgml file')

	g = PgmlGraph('PgmlGraph',debug,idSequence,usePostgreSqlIsa)
	g.read(pgmlFilename)
	if simplify:
		g.simplify()

	output = stdout
	if dotFilename:
		output = open(dotFilename,'w')
	g.write_dot(output, dotOptions, tableNames)

if __name__ == '__main__':
	main()
