################################################################################
##$Namespace: checksum
##$Version: 1.0.0
##$Author: Michael E Allen
##$Copyright: Copyright(C)2001 Michael E Allen
##$License: GNU General Public License
##$Create Date: April 23, 2001
##$Description: Provides components for calculating checksums
##$Bugs: 
##+	None
##$To Do: 
##+	Nothing
##$Changes:
##+	None
##$Disclaimer:
##+	This program is free software; you can redistribute it and/or modify
##+	it under the terms of the GNU General Public License as published by
##+	the Free Software Foundation; either version 2 of the License, or
##+	(at your option) any later version.
##+	This program is distributed in the hope that it will be useful,
##+	but WITHOUT ANY WARRANTY; without even the implied warranty of
##+	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##+	GNU General Public License for more details.
##+	
##+	You should have received a copy of the GNU General Public License
##+	along with this program; if not, write to the Free Software
##+	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
################################################################################
namespace eval ::math::checksum {

	################################################################################
	##$Procedure: IndentifyCard
	##$Purpose: Deteremines the name of a card type
	##$Version: 1.0.0
	##$Author: Michael E Allen
	##$Create Date: April 23, 2001
	##$Description:
	##+	None
	##$Bugs: 
	##+	None
	##$To Do: 
	##+	Nothing
	##$Changes:
	##+	None
	##$Synopsis:
	##+	::process::Top
	##$Parameters:
	##+	None
	##$Result:
	##+	Not done
	################################################################################
	proc IdentifyCard {pCardNumber} {
		regsub -all {[ -]} $pCardNumber {} lCardNumber
		set lCardNumberLength [string length $lCardNumber]
		set lCardType -1
	
		switch -glob [string range $lCardNumber 0 3] {
			"51??" -  "52??" -  "53??" -  "54??" -  "55??"  {
				if {($lCardNumberLength == 16)} {
					set lCardType "MasterCard"
				}
			}
	
			"4???" {
				if {($lCardNumberLength == 13) || ($lCardNumberLength == 16)} {
					set lCardType "VISA"
				}
			}
			"34??" -  "37??" {
				if {($lCardNumberLength == 15)}  {
					set lCardType "American Express"
				}
			}
	
			"300?" -  "301?" -  "302?" -  "303?" - \
			"304?" - "305?" -  "36??" -   "38??" {
				if {($lCardNumberLength == 14)} {
					set lCardType "Diner's Club/Carte Blanche"
				}
			}
	
			"6011" {
				if {($lCardNumberLength == 16)} {
					set lCardType "Discover"
				}
			}
	
			"2014" -  "2149" {
				if {($lCardNumberLength == 15)} {
					set lCardType "enRoute"
				}
			}
			
			"3???" {
				if {($lCardNumberLength == 16)} {
					set lCardType "JCB"
				}
			}
	
			"2131" -  "1800" {
				if {($lCardNumberLength == 15)} {
					set lCardType "JCB"
				}
			}
	
			"????" {
				if {($lCardNumberLength == 12)} {
					set lCardType "DIRECTV Access Card"
				}
			}
		}
	
		return $lCardType
	}
	
	################################################################################
	##$Procedure: Mod10
	##$Purpose: Performs a Mod10 validation on a card number
	##$Version: 1.0.0
	##$Author: Michael E Allen
	##$Create Date: April 23, 2001
	##$Description:
	##+	None
	##$Bugs: 
	##+	None
	##$To Do: 
	##+	Nothing
	##$Changes:
	##+	None
	##$Synopsis:
	##+	::process::Top
	##$Parameters:
	##+	None
	##$Result:
	##+	Not done
	################################################################################
	proc Mod10 {pNumber} {
		regsub -all {[ -]} $pNumber {} lNumber
		set lNumberLength [string length $lNumber]
		set lNumber [split $lNumber {}]
	
		set lSum 0
		set lResult 0
		
		regsub -all {[0-9]} $pNumber {} lTest
	
		if {($lTest != "")} {
			return -1
		}
		
		for {set lIndex [expr $lNumberLength - 1]} {$lIndex >= 0} {} {
			incr lSum [lindex $lNumber $lIndex]
			if {[incr lIndex -1] >= 0} {
				foreach lDigit  [split [expr 2 * [lindex $lNumber $lIndex]] {}] {
					incr lSum $lDigit
				}
				incr lIndex -1
			}
		}
		
		set lSum [split $lSum {}]
		if {[lindex $lSum [expr [llength $lSum] - 1]]} {
			set lResult -1
		}
		
		return $lResult
	}
	
	################################################################################
	##$Procedure: Encode
	##$Purpose: Verifies that a given card number is correct
	##$Version: 1.0.0
	##$Author: Michael E Allen
	##$Create Date: April 23, 2001
	##$Description:
	##+	None
	##$Bugs: 
	##+	None
	##$To Do: 
	##+	Nothing
	##$Changes:
	##+	None
	##$Synopsis:
	##+	::process::Top
	##$Parameters:
	##+	None
	##$Result:
	##+	Not done
	################################################################################
	proc ValidateCard {pCardNumber} {
		set lResult -1
		set lCardType [::math::checksum::IdentifyCard $pCardNumber]
	
		if {($lCardType == "enRoute")} {
			set lResult $lCardType
		} elseif {($lCardType != "")} {
			set lError [::math::checksum::Mod10 $pCardNumber]
			if {($lError == 0)} {
				set lResult $lCardType
			}
		} 
		
		return $lResult
	}
}
